/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg;

import com.atlassian.fisheye.hg.HgCache;
import com.atlassian.fisheye.hg.HgTestBase;
import com.atlassian.fisheye.hg.HgTestHarness;
import com.atlassian.fisheye.hg.db.HgChangeSet;
import com.cenqua.fisheye.config.ConfigException;
import org.junit.Assert;
import org.junit.Test;

public class HgHttpAuthenticationTest
extends HgTestBase {
    private static final String URL_HTTPS = "bitbucket.org/fecrutest/hg-auth";
    private static final String CORRECT_USERNAME = "fecrutest";
    private static final String CORRECT_PASSWORD = "h6i8LvUo";

    @Test
    public void testHttpsAuthenticationBadUsername() throws Exception {
        this.runExpectedFail("https", "wrong", CORRECT_PASSWORD, URL_HTTPS);
    }

    @Test
    public void testHttpsAuthenticationBadPassword() throws Exception {
        this.runExpectedFail("https", CORRECT_USERNAME, "wrong", URL_HTTPS);
    }

    @Test
    public void testHttpsAuthentication() throws Exception {
        this.runTest("https", CORRECT_USERNAME, CORRECT_PASSWORD, URL_HTTPS);
    }

    private void runExpectedFail(String protocol, String username, String password, String url) throws Exception {
        try {
            this.runTest(protocol, username, password, url);
        }
        catch (ConfigException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Unable to pull from remote repository"));
            return;
        }
        Assert.fail((String)"Bad credentials didn't stop indexing");
    }

    private void runTest(String protocol, String username, String password, String url) throws Exception {
        ((HgTestHarness)this.testHarness).setPassword(password);
        this.slurpRemote(this.getUrl(protocol, username, url));
        ((HgTestHarness)this.testHarness).assertNoSlurpErrors("There were slurp errors");
        HgChangeSet changeset = (HgChangeSet)((HgCache)this.getCache()).getChangeSet("7a13ad9e7c142d8fce7cdbfe97bc3a1be447a1e8");
        Assert.assertNotNull((Object)changeset);
        Assert.assertEquals((Object)"7a13ad9e7c142d8fce7cdbfe97bc3a1be447a1e8", (Object)changeset.getId());
        Assert.assertEquals((long)1L, (long)changeset.getRevisionInfosCount());
    }

    private String getUrl(String protocol, String username, String url) {
        return protocol + "://" + username + "@" + url;
    }
}

