/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg;

import com.atlassian.fisheye.dvcs.DvcsRepoValidation;
import com.atlassian.fisheye.dvcs.db.DvcsHeadnessTestUtil;
import com.atlassian.fisheye.hg.HgCache;
import com.atlassian.fisheye.hg.HgIncrementalTestCase;
import com.atlassian.fisheye.hg.db.HgChangeSet;
import com.atlassian.fisheye.hg.db.HgRevInfo;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.RevInfoKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class HgHeadnessTest
extends HgIncrementalTestCase {
    protected DvcsRepoValidation.Revision file1Rev0 = new DvcsRepoValidation.Revision("file1.txt", "828762473510069fa17ec7151d1c86205ff9b71d", (List<String>)NO_PARENTS, "hguser", "Incremental test starting point", 1278293268000L, "default", DvcsRepoValidation.RevState.Added, "file1.txt", false, 1, 1, 0);
    protected DvcsRepoValidation.Revision file2Rev0 = new DvcsRepoValidation.Revision("sub/file2.txt", "828762473510069fa17ec7151d1c86205ff9b71d", (List<String>)NO_PARENTS, "hguser", "Incremental test starting point", 1278293268000L, "default", DvcsRepoValidation.RevState.Added, "sub/file2.txt", false, 1, 1, 0);
    protected HgIncrementalTestCase.Step initial = new HgIncrementalTestCase.Step.Builder("incremental-initial").commits(DvcsRepoValidation.Commits.first("828762473510069fa17ec7151d1c86205ff9b71d", "hguser", "Incremental test starting point", "default", 1278293268000L, 2).l()).revs(DvcsRepoValidation.FileRevs.file("file1.txt").rev(this.file1Rev0)).revs(DvcsRepoValidation.FileRevs.file("sub/file2.txt").rev(this.file2Rev0)).build();

    @Test
    public void testPlainModification() throws Exception {
        DvcsRepoValidation.Revision file1Rev1 = new DvcsRepoValidation.Revision("file1.txt", "f70b3e8d40cd67b4da3c9c0a9e6a1d438f3a17b2", Arrays.asList("828762473510069fa17ec7151d1c86205ff9b71d"), "hguser", "added a line to file1.txt", 1278293352000L, "default", DvcsRepoValidation.RevState.Modified, "file1.txt", false, 2, 1, 0);
        HgIncrementalTestCase.Step plain1 = new HgIncrementalTestCase.Step.Builder("plain-1").commits(DvcsRepoValidation.Commits.first("f70b3e8d40cd67b4da3c9c0a9e6a1d438f3a17b2", "828762473510069fa17ec7151d1c86205ff9b71d", "hguser", "added a line to file1.txt", "default", 1278293352000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file("file1.txt").rev(file1Rev1)).validator(new HeadnessValidator().addHead("f70b3e8d40cd67b4da3c9c0a9e6a1d438f3a17b2", file1Rev1, this.file2Rev0)).build();
        DvcsRepoValidation.Revision file2Rev2 = new DvcsRepoValidation.Revision("sub/file2.txt", "94993fc41c9ee0dd1959b4312a48a65fba19a3ca", Arrays.asList("828762473510069fa17ec7151d1c86205ff9b71d"), "hguser", "moved file2.txt to file3.txt", 1278293473000L, "default", DvcsRepoValidation.RevState.Deleted, "sub/file2.txt", false, 0, 0, 1);
        DvcsRepoValidation.Revision file3Rev2 = new DvcsRepoValidation.Revision("sub/file3.txt", "94993fc41c9ee0dd1959b4312a48a65fba19a3ca", Arrays.asList("828762473510069fa17ec7151d1c86205ff9b71d"), "hguser", "moved file2.txt to file3.txt", 1278293473000L, "default", DvcsRepoValidation.RevState.Renamed, "sub/file2.txt", false, 1, 0, 0);
        HgIncrementalTestCase.Step plain2 = new HgIncrementalTestCase.Step.Builder("plain-2").commits(DvcsRepoValidation.Commits.first("94993fc41c9ee0dd1959b4312a48a65fba19a3ca", "f70b3e8d40cd67b4da3c9c0a9e6a1d438f3a17b2", "hguser", "moved file2.txt to file3.txt", "default", 1278293473000L, 2).l()).revs(DvcsRepoValidation.FileRevs.file("sub/file3.txt").rev(file3Rev2)).revs(DvcsRepoValidation.FileRevs.file("sub/file2.txt").rev(file2Rev2)).validator(new HeadnessValidator().addHead("94993fc41c9ee0dd1959b4312a48a65fba19a3ca", file1Rev1, file2Rev2, file3Rev2)).build();
        DvcsRepoValidation.Revision file4rev3 = new DvcsRepoValidation.Revision("sub/file4.bin", "888d90f8bbf0ce03b1f555c021b0127beded714f", (List<String>)NO_PARENTS, "hguser", "Added file4.bin", 1278293718000L, "default", DvcsRepoValidation.RevState.Added, "sub/file4.bin", true, 0, 0, 0);
        HgIncrementalTestCase.Step plain3 = new HgIncrementalTestCase.Step.Builder("plain-3").commits(DvcsRepoValidation.Commits.first("888d90f8bbf0ce03b1f555c021b0127beded714f", "94993fc41c9ee0dd1959b4312a48a65fba19a3ca", "hguser", "Added file4.bin", "default", 1278293718000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file("sub/file4.bin").rev(file4rev3)).validator(new HeadnessValidator().addHead("888d90f8bbf0ce03b1f555c021b0127beded714f", file1Rev1, file2Rev2, file3Rev2, file4rev3)).build();
        DvcsRepoValidation.Revision file1Rev4 = new DvcsRepoValidation.Revision("file1.txt", "bb13eda6e02a1b5ae981f7839d2b32c42569b5a8", Arrays.asList("f70b3e8d40cd67b4da3c9c0a9e6a1d438f3a17b2"), "hguser", "deleted file1.txt", 1278293772000L, "default", DvcsRepoValidation.RevState.Deleted, "file1.txt", false, 0, 0, 2);
        HgIncrementalTestCase.Step plain4 = new HgIncrementalTestCase.Step.Builder("plain-4").commits(DvcsRepoValidation.Commits.first("bb13eda6e02a1b5ae981f7839d2b32c42569b5a8", "888d90f8bbf0ce03b1f555c021b0127beded714f", "hguser", "deleted file1.txt", "default", 1278293772000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file("file1.txt").rev(file1Rev4)).validator(new HeadnessValidator().addHead("bb13eda6e02a1b5ae981f7839d2b32c42569b5a8", file1Rev4, file2Rev2, file3Rev2, file4rev3)).build();
        this.incrementalTest(this.initial, plain1, plain2, plain3, plain4);
    }

    @Test
    public void testNamedBranches() throws Exception {
        HgIncrementalTestCase.Step branchAndMerge1 = new HgIncrementalTestCase.Step.Builder("inc-branch-merge-1").commits(DvcsRepoValidation.Commits.first("808bc0dcebbefa489f253de1ebe68f0686f48a1d", "828762473510069fa17ec7151d1c86205ff9b71d", "hguser", "created branch1", "branch1", 1278299306000L, 0).l()).validator(new HeadnessValidator().addHead("828762473510069fa17ec7151d1c86205ff9b71d", this.file1Rev0, this.file2Rev0).addHead("808bc0dcebbefa489f253de1ebe68f0686f48a1d", this.file1Rev0, this.file2Rev0)).build();
        DvcsRepoValidation.Revision file2Rev2 = new DvcsRepoValidation.Revision("sub/file2.txt", "02e28770d1e332c31f837ce2af8baf1061edff98", Arrays.asList("828762473510069fa17ec7151d1c86205ff9b71d"), "hguser", "deleted file2.txt", 1278299631000L, "branch1", DvcsRepoValidation.RevState.Deleted, "sub/file2.txt", false, 0, 0, 1);
        HgIncrementalTestCase.Step branchAndMerge2 = new HgIncrementalTestCase.Step.Builder("inc-branch-merge-2").commits(DvcsRepoValidation.Commits.first("02e28770d1e332c31f837ce2af8baf1061edff98", "808bc0dcebbefa489f253de1ebe68f0686f48a1d", "hguser", "deleted file2.txt", "branch1", 1278299631000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file("sub/file2.txt").rev(file2Rev2)).validator(new HeadnessValidator().addHead("828762473510069fa17ec7151d1c86205ff9b71d", this.file1Rev0, this.file2Rev0).addHead("02e28770d1e332c31f837ce2af8baf1061edff98", this.file1Rev0, file2Rev2)).build();
        DvcsRepoValidation.Revision file2Rev3 = new DvcsRepoValidation.Revision("sub/file2.txt", "aed9dcd805bc7edfa1776f73515db0b9e3763eda", Arrays.asList("828762473510069fa17ec7151d1c86205ff9b71d"), "hguser", "altered file2.txt", 1278299697000L, "default", DvcsRepoValidation.RevState.Modified, "sub/file2.txt", false, 2, 1, 0);
        HgIncrementalTestCase.Step branchAndMerge3 = new HgIncrementalTestCase.Step.Builder("inc-branch-merge-3").commits(DvcsRepoValidation.Commits.first("aed9dcd805bc7edfa1776f73515db0b9e3763eda", "828762473510069fa17ec7151d1c86205ff9b71d", "hguser", "altered file2.txt", "default", 1278299697000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file("sub/file2.txt").rev(file2Rev3)).validator(new HeadnessValidator().addHead("aed9dcd805bc7edfa1776f73515db0b9e3763eda", this.file1Rev0, file2Rev3).addHead("02e28770d1e332c31f837ce2af8baf1061edff98", this.file1Rev0, file2Rev2)).build();
        HgIncrementalTestCase.Step branchAndMerge4 = new HgIncrementalTestCase.Step.Builder("inc-branch-merge-4").commits(DvcsRepoValidation.Commits.first("f767f0106b3126d2a0de357fdeeb81dc6106deab", Arrays.asList("aed9dcd805bc7edfa1776f73515db0b9e3763eda", "02e28770d1e332c31f837ce2af8baf1061edff98"), "hguser", "merged branch1 to default", "default", 1278299827000L, 0).l()).validator(new HeadnessValidator().addHead("f767f0106b3126d2a0de357fdeeb81dc6106deab", this.file1Rev0, file2Rev3).addHead("02e28770d1e332c31f837ce2af8baf1061edff98", this.file1Rev0, file2Rev2)).build();
        DvcsRepoValidation.Revision file3Rev5 = new DvcsRepoValidation.Revision("file3.zip", "afcc494cbfb9094898ba02047e9bedf87c1999ef", (List<String>)NO_PARENTS, "hguser", "added file3.zip", 1278299890000L, "branch1", DvcsRepoValidation.RevState.Added, "file3.zip", true, 0, 0, 0);
        HgIncrementalTestCase.Step branchAndMerge5 = new HgIncrementalTestCase.Step.Builder("inc-branch-merge-5").commits(DvcsRepoValidation.Commits.first("afcc494cbfb9094898ba02047e9bedf87c1999ef", "02e28770d1e332c31f837ce2af8baf1061edff98", "hguser", "added file3.zip", "branch1", 1278299890000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file("file3.zip").rev(file3Rev5)).validator(new HeadnessValidator().addHead("f767f0106b3126d2a0de357fdeeb81dc6106deab", this.file1Rev0, file2Rev3).addHead("afcc494cbfb9094898ba02047e9bedf87c1999ef", this.file1Rev0, file2Rev2, file3Rev5)).build();
        HgIncrementalTestCase.Step branchAndMerge6 = new HgIncrementalTestCase.Step.Builder("inc-branch-merge-6").commits(DvcsRepoValidation.Commits.first("2c923f0473d327a92aef74af45de5d91676e187c", Arrays.asList("f767f0106b3126d2a0de357fdeeb81dc6106deab", "afcc494cbfb9094898ba02047e9bedf87c1999ef"), "hguser", "merged branch1 --> default (again)", "default", 1278299934000L, 0).l()).validator(new HeadnessValidator().addHead("2c923f0473d327a92aef74af45de5d91676e187c", this.file1Rev0, file2Rev3, file3Rev5).addHead("afcc494cbfb9094898ba02047e9bedf87c1999ef", this.file1Rev0, file2Rev2, file3Rev5)).build();
        this.incrementalTest(this.initial, branchAndMerge1, branchAndMerge2, branchAndMerge3, branchAndMerge4, branchAndMerge5, branchAndMerge6);
    }

    public class HeadnessValidator
    implements HgIncrementalTestCase.Validator {
        private Map<String, List<DvcsRepoValidation.Revision>> headMap = new HashMap<String, List<DvcsRepoValidation.Revision>>();

        protected Set<RevInfoKey> revisionToRevInfoKeys(Collection<DvcsRepoValidation.Revision> revisions) {
            HashSet<RevInfoKey> revKeys = new HashSet<RevInfoKey>();
            for (DvcsRepoValidation.Revision rev : revisions) {
                revKeys.add(new RevInfoKey(new Path((CharSequence)rev.name), rev.rev));
            }
            return revKeys;
        }

        protected Set<RevInfoKey> revInfoToRevInfoKeys(Collection<HgRevInfo> revisions) {
            HashSet<RevInfoKey> revKeys = new HashSet<RevInfoKey>();
            for (HgRevInfo rev : revisions) {
                revKeys.add(rev.getRevInfoKey());
            }
            return revKeys;
        }

        public HeadnessValidator addHead(String head, DvcsRepoValidation.Revision ... revs) {
            this.headMap.put(head, Arrays.asList(revs));
            return this;
        }

        @Override
        public void validate(HgCache cache, HgIncrementalTestCase.Step step) throws Exception {
            DvcsHeadnessTestUtil testUtil = new DvcsHeadnessTestUtil(cache.getInfDb(), cache.getFileRevisionDAO());
            HashSet<RevInfoKey> allExpectedHeadRevs = new HashSet<RevInfoKey>();
            for (Map.Entry<String, List<DvcsRepoValidation.Revision>> headEntry : this.headMap.entrySet()) {
                HgChangeSet cs = (HgChangeSet)cache.getChangeSet(headEntry.getKey());
                List<HgRevInfo> actualHeadsOnBranch = testUtil.getHeadsOnBranch(cs.getBranch());
                Set<RevInfoKey> actualHeadRevs = this.revInfoToRevInfoKeys(actualHeadsOnBranch);
                Set<RevInfoKey> expectedHeadRevs = this.revisionToRevInfoKeys((Collection<DvcsRepoValidation.Revision>)headEntry.getValue());
                Assert.assertEquals((String)(step.target + ":Manifest for commit " + headEntry.getKey() + " on branch " + cs.getBranch() + " don't match"), expectedHeadRevs, actualHeadRevs);
                allExpectedHeadRevs.addAll(expectedHeadRevs);
            }
            List<HgRevInfo> actualHeadsOnAnyBranch = testUtil.getHeadsOnAnyBranch();
            Set<RevInfoKey> actualHeadRevs = this.revInfoToRevInfoKeys(actualHeadsOnAnyBranch);
            Assert.assertEquals((String)(step.target + ":Heads on any branch doesn't match"), allExpectedHeadRevs, actualHeadRevs);
        }
    }
}

