/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg;

import com.atlassian.fisheye.dvcs.DvcsRepoValidation;
import com.atlassian.fisheye.hg.HgCache;
import com.atlassian.fisheye.hg.HgSlurpTestBase;
import com.atlassian.fisheye.hg.db.HgRevInfo;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class HgCopyMoveSlurpTest
extends HgSlurpTestBase {
    public HgCopyMoveSlurpTest() {
        super("copy-move");
    }

    @Test
    public void testCopyMoveSlurp() throws Exception {
        this.assertCommitData(DvcsRepoValidation.Commits.first("b624135a3f44db1fa2c6797b3ca96fd148767d38", "abuttfield", "first commit", "default", 1270021639000L, 1).next("992a1c5691252f1ecddd05f8f59ed013bc5db157", "b624135a3f44db1fa2c6797b3ca96fd148767d38", "abuttfield", "testing file copy", "default", 1270021662000L, 1).next("afa20009f52fc9ae142456fdf90e5189bbe7656e", "992a1c5691252f1ecddd05f8f59ed013bc5db157", "abuttfield", "testing file move", "default", 1270021690000L, 2).next("1ecfac8ed72b79379b7943aa386005780eb89d7d", "afa20009f52fc9ae142456fdf90e5189bbe7656e", "abuttfield", "rename (with edit) file2.txt to file4.txt", "default", 1270089483000L, 2).next("57e287c5821e562030f709518123b0a1415b41ad", "1ecfac8ed72b79379b7943aa386005780eb89d7d", "abuttfield", "copy (with edit) file3.txt to file5.txt", "default", 1270089552000L, 1).next("04e2173c0ea148f624220038a4f84802a253352e", "57e287c5821e562030f709518123b0a1415b41ad", "mwatson", "copy5->6 and mod 5 afterwards", "default", 1271661676000L, 2).next("5a3a4b8b9ebf4d71ccc626bf55e220c42b082fe4", "04e2173c0ea148f624220038a4f84802a253352e", "mwatson", "rm file3 and then copy file5->file3", "default", 1273044108000L, 1).next("a7da26474573d74886fa56bb6b0f8e98c0040037", "5a3a4b8b9ebf4d71ccc626bf55e220c42b082fe4", "hguser", "moved file3.txt -> file7.txt, added a new file3.txt", "default", 1282086471000L, 2).next("69c337b7adbb4e963e81e64496e5a07a35b1ea17", "a7da26474573d74886fa56bb6b0f8e98c0040037", "hguser", "moved file3.txt -> file8.txt, moved file7.txt -> file3.txt", "default", 1282086524000L, 3).l());
        this.assertRevisionData(DvcsRepoValidation.FileRevs.file("file2.txt").rev("992a1c5691252f1ecddd05f8f59ed013bc5db157", "b624135a3f44db1fa2c6797b3ca96fd148767d38", null, "abuttfield", "testing file copy", 1270021662000L, "default", DvcsRepoValidation.RevState.Copied, "file1.txt", false, 1, 0, 0).rev("1ecfac8ed72b79379b7943aa386005780eb89d7d", "992a1c5691252f1ecddd05f8f59ed013bc5db157", null, "abuttfield", "rename (with edit) file2.txt to file4.txt", 1270089483000L, "default", DvcsRepoValidation.RevState.Deleted, "file2.txt", false, 0, 0, 1));
        this.assertRevisionData(DvcsRepoValidation.FileRevs.file("file1.txt").rev("b624135a3f44db1fa2c6797b3ca96fd148767d38", null, null, "abuttfield", "first commit", 1270021639000L, "default", DvcsRepoValidation.RevState.Added, "file1.txt", false, 1, 1, 0).rev("afa20009f52fc9ae142456fdf90e5189bbe7656e", "b624135a3f44db1fa2c6797b3ca96fd148767d38", null, "abuttfield", "testing file move", 1270021690000L, "default", DvcsRepoValidation.RevState.Deleted, "file1.txt", false, 0, 0, 1));
        this.assertRevisionData(DvcsRepoValidation.FileRevs.file("file4.txt").rev("1ecfac8ed72b79379b7943aa386005780eb89d7d", "992a1c5691252f1ecddd05f8f59ed013bc5db157", null, "abuttfield", "rename (with edit) file2.txt to file4.txt", 1270089483000L, "default", DvcsRepoValidation.RevState.Renamed, "file2.txt", false, 2, 1, 0));
        this.assertRevisionData(DvcsRepoValidation.FileRevs.file("file3.txt").rev("afa20009f52fc9ae142456fdf90e5189bbe7656e", "b624135a3f44db1fa2c6797b3ca96fd148767d38", null, "abuttfield", "testing file move", 1270021690000L, "default", DvcsRepoValidation.RevState.Renamed, "file1.txt", false, 1, 0, 0).rev("5a3a4b8b9ebf4d71ccc626bf55e220c42b082fe4", "04e2173c0ea148f624220038a4f84802a253352e", null, "mwatson", "rm file3 and then copy file5->file3", 1273044108000L, "default", DvcsRepoValidation.RevState.Copied, "file5.txt", false, 2, 0, 0).rev("a7da26474573d74886fa56bb6b0f8e98c0040037", "5a3a4b8b9ebf4d71ccc626bf55e220c42b082fe4", null, "hguser", "moved file3.txt -> file7.txt, added a new file3.txt", 1282086471000L, "default", DvcsRepoValidation.RevState.Modified, "file3.txt", false, 1, 1, 2).rev("69c337b7adbb4e963e81e64496e5a07a35b1ea17", "a7da26474573d74886fa56bb6b0f8e98c0040037", null, "hguser", "moved file3.txt -> file8.txt, moved file7.txt -> file3.txt", 1282086524000L, "default", DvcsRepoValidation.RevState.Renamed, "file7.txt", false, 2, 0, 0));
        this.assertRevisionData(DvcsRepoValidation.FileRevs.file("file6.txt").rev("04e2173c0ea148f624220038a4f84802a253352e", "57e287c5821e562030f709518123b0a1415b41ad", null, "mwatson", "copy5->6 and mod 5 afterwards", 1271661676000L, "default", DvcsRepoValidation.RevState.Copied, "file5.txt", false, 1, 0, 0));
        this.assertRevisionData(DvcsRepoValidation.FileRevs.file("file5.txt").rev("57e287c5821e562030f709518123b0a1415b41ad", "afa20009f52fc9ae142456fdf90e5189bbe7656e", null, "abuttfield", "copy (with edit) file3.txt to file5.txt", 1270089552000L, "default", DvcsRepoValidation.RevState.Copied, "file3.txt", false, 1, 1, 1).rev("04e2173c0ea148f624220038a4f84802a253352e", "57e287c5821e562030f709518123b0a1415b41ad", null, "mwatson", "copy5->6 and mod 5 afterwards", 1271661676000L, "default", DvcsRepoValidation.RevState.Modified, "file5.txt", false, 2, 1, 0));
        this.assertRevisionData(DvcsRepoValidation.FileRevs.file("file8.txt").rev("69c337b7adbb4e963e81e64496e5a07a35b1ea17", "a7da26474573d74886fa56bb6b0f8e98c0040037", null, "hguser", "moved file3.txt -> file8.txt, moved file7.txt -> file3.txt", 1282086524000L, "default", DvcsRepoValidation.RevState.Copied, "file3.txt", false, 1, 0, 0));
        this.assertRevisionData(DvcsRepoValidation.FileRevs.file("file7.txt").rev("a7da26474573d74886fa56bb6b0f8e98c0040037", "5a3a4b8b9ebf4d71ccc626bf55e220c42b082fe4", null, "hguser", "moved file3.txt -> file7.txt, added a new file3.txt", 1282086471000L, "default", DvcsRepoValidation.RevState.Copied, "file3.txt", false, 2, 0, 0).rev("69c337b7adbb4e963e81e64496e5a07a35b1ea17", "a7da26474573d74886fa56bb6b0f8e98c0040037", null, "hguser", "moved file3.txt -> file8.txt, moved file7.txt -> file3.txt", 1282086524000L, "default", DvcsRepoValidation.RevState.Deleted, "file7.txt", false, 0, 0, 2));
        this.verifyBasicCopy();
        this.verifyCopyWithEditedDestination();
        this.verifyCopyWithEditedSource();
        this.verifyRemoveAndCopy();
        this.verifyBasicMove();
        this.verifyMovedFileReplacedWithNewFileInSingleCommit();
        this.verifyMovedFileReplaceByMovedFileInSingleCommit();
    }

    public void verifyBasicCopy() throws Exception {
        DvcsRepoValidation.Revision expected = new DvcsRepoValidation.Revision("file2.txt", "992a1c5691252f1ecddd05f8f59ed013bc5db157", Arrays.asList("b624135a3f44db1fa2c6797b3ca96fd148767d38"), "abuttfield", "testing file copy", 1270021662000L, "default", DvcsRepoValidation.RevState.Copied, "file1.txt", false, 1, 0, 0);
        this.assertRevisionEquals(expected, this.getActualRevInfo(expected));
    }

    public void verifyCopyWithEditedSource() throws Exception {
        HgRevInfo file5RevAncestor = (HgRevInfo)((HgCache)this.getCache()).getFileHistory(new Path((CharSequence)"file5.txt")).getRevision("57e287c5821e562030f709518123b0a1415b41ad");
        HgRevInfo file5Rev = (HgRevInfo)((HgCache)this.getCache()).getFileHistory(new Path((CharSequence)"file5.txt")).getRevision("04e2173c0ea148f624220038a4f84802a253352e");
        HgRevInfo file6Rev = (HgRevInfo)((HgCache)this.getCache()).getFileHistory(new Path((CharSequence)"file6.txt")).getRevision("04e2173c0ea148f624220038a4f84802a253352e");
        Assert.assertNotNull((Object)file6Rev.getAncestorLink());
        Assert.assertTrue((boolean)file6Rev.getAncestorLink().isCopy());
        Assert.assertEquals((long)1L, (long)file6Rev.getAncestorLink().getRevids().size());
        Assert.assertEquals((long)file5RevAncestor.getRevID(), (long)file6Rev.getAncestorLink().getRevids().getInt(0));
        Assert.assertNotNull((Object)file5Rev.getAncestorLink());
        Assert.assertTrue((boolean)file5Rev.getAncestorLink().isDirect());
        Assert.assertEquals((long)1L, (long)file5Rev.getAncestorLink().getRevids().size());
        Assert.assertEquals((long)file5RevAncestor.getRevID(), (long)file5Rev.getAncestorLink().getRevids().getInt(0));
    }

    public void verifyCopyWithEditedDestination() throws Exception {
        HgRevInfo file3RevAncestor = (HgRevInfo)((HgCache)this.getCache()).getFileHistory(new Path((CharSequence)"file3.txt")).getRevision("afa20009f52fc9ae142456fdf90e5189bbe7656e");
        HgRevInfo file5Rev = (HgRevInfo)((HgCache)this.getCache()).getFileHistory(new Path((CharSequence)"file5.txt")).getRevision("57e287c5821e562030f709518123b0a1415b41ad");
        Assert.assertNotNull((Object)file5Rev.getAncestorLink());
        Assert.assertTrue((boolean)file5Rev.getAncestorLink().isCopy());
        Assert.assertEquals((long)1L, (long)file5Rev.getAncestorLink().getRevids().size());
        Assert.assertEquals((long)file3RevAncestor.getRevID(), (long)file5Rev.getAncestorLink().getRevids().getInt(0));
        Assert.assertEquals((long)1L, (long)file5Rev.getLinesRemoved());
        Assert.assertEquals((long)1L, (long)file5Rev.getLinesAdded());
        Assert.assertEquals((long)1L, (long)file5Rev.getLineCount());
    }

    public void verifyRemoveAndCopy() throws DbException {
        DvcsRepoValidation.Revision expectedFile3CpRev = new DvcsRepoValidation.Revision("file3.txt", "5a3a4b8b9ebf4d71ccc626bf55e220c42b082fe4", Arrays.asList("04e2173c0ea148f624220038a4f84802a253352e"), "mwatson", "rm file3 and then copy file5->file3", 1273044108000L, "default", DvcsRepoValidation.RevState.Copied, "file5.txt", false, 2, 0, 0);
        this.assertRevisionEquals(expectedFile3CpRev, this.getActualRevInfo(expectedFile3CpRev));
    }

    public void verifyBasicMove() throws Exception {
        this.assertRevisionData(DvcsRepoValidation.FileRevs.file("file1.txt").rev("b624135a3f44db1fa2c6797b3ca96fd148767d38", null, null, "abuttfield", "first commit", 1270021639000L, "default", DvcsRepoValidation.RevState.Added, "file1.txt", false, 1, 1, 0).rev("afa20009f52fc9ae142456fdf90e5189bbe7656e", "b624135a3f44db1fa2c6797b3ca96fd148767d38", null, "abuttfield", "testing file move", 1270021690000L, "default", DvcsRepoValidation.RevState.Deleted, null, false, 0, 0, 1));
    }

    public void verifyMovedFileReplacedWithNewFileInSingleCommit() throws DbException {
        DvcsRepoValidation.Revision expectedFile7CpRev = new DvcsRepoValidation.Revision("file7.txt", "a7da26474573d74886fa56bb6b0f8e98c0040037", Arrays.asList("5a3a4b8b9ebf4d71ccc626bf55e220c42b082fe4"), "hguser", "moved file3.txt -> file7.txt, added a new file3.txt", 1282086471000L, "default", DvcsRepoValidation.RevState.Copied, "file3.txt", false, 2, 0, 0);
        DvcsRepoValidation.Revision expectedFile3ModRev = new DvcsRepoValidation.Revision("file3.txt", "a7da26474573d74886fa56bb6b0f8e98c0040037", Arrays.asList("5a3a4b8b9ebf4d71ccc626bf55e220c42b082fe4"), "hguser", "moved file3.txt -> file7.txt, added a new file3.txt", 1282086471000L, "default", DvcsRepoValidation.RevState.Modified, "file3.txt", false, 1, 1, 2);
        this.assertRevisionEquals(expectedFile7CpRev, this.getActualRevInfo(expectedFile7CpRev));
        this.assertRevisionEquals(expectedFile3ModRev, this.getActualRevInfo(expectedFile3ModRev));
    }

    public void verifyMovedFileReplaceByMovedFileInSingleCommit() throws DbException {
        DvcsRepoValidation.Revision expectedFile8CpRev = new DvcsRepoValidation.Revision("file8.txt", "69c337b7adbb4e963e81e64496e5a07a35b1ea17", Arrays.asList("a7da26474573d74886fa56bb6b0f8e98c0040037"), "hguser", "moved file3.txt -> file8.txt, moved file7.txt -> file3.txt", 1282086524000L, "default", DvcsRepoValidation.RevState.Copied, "file3.txt", false, 1, 0, 0);
        DvcsRepoValidation.Revision expectedFile3MvRev = new DvcsRepoValidation.Revision("file3.txt", "69c337b7adbb4e963e81e64496e5a07a35b1ea17", Arrays.asList("a7da26474573d74886fa56bb6b0f8e98c0040037"), "hguser", "moved file3.txt -> file8.txt, moved file7.txt -> file3.txt", 1282086524000L, "default", DvcsRepoValidation.RevState.Renamed, "file7.txt", false, 2, 0, 0);
        DvcsRepoValidation.Revision expectedFile7DelRev = new DvcsRepoValidation.Revision("file7.txt", "69c337b7adbb4e963e81e64496e5a07a35b1ea17", Arrays.asList("a7da26474573d74886fa56bb6b0f8e98c0040037"), "hguser", "moved file3.txt -> file8.txt, moved file7.txt -> file3.txt", 1282086524000L, "default", DvcsRepoValidation.RevState.Deleted, "file7.txt", false, 0, 0, 2);
        this.assertRevisionEquals(expectedFile8CpRev, this.getActualRevInfo(expectedFile8CpRev));
        this.assertRevisionEquals(expectedFile3MvRev, this.getActualRevInfo(expectedFile3MvRev));
        this.assertRevisionEquals(expectedFile7DelRev, this.getActualRevInfo(expectedFile7DelRev));
    }
}

