/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg;

import com.atlassian.fisheye.bucket.BucketData;
import com.atlassian.fisheye.bucket.BucketDataCollectionTotalled;
import com.atlassian.fisheye.bucket.BucketGraph;
import com.atlassian.fisheye.bucket.ParameterSetQuery;
import com.atlassian.fisheye.hg.HgRepositoryEngine;
import com.atlassian.fisheye.hg.HgTestBase;
import com.atlassian.fisheye.hg.HgTestHarness;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import java.util.TimeZone;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HgBranchLocTest
extends HgTestBase {
    private BucketGraph dataCollector;

    @Before
    public void setUp() throws Exception {
        this.slurpDump("test-branch-loc");
        HgRepositoryEngine engine = (HgRepositoryEngine)((HgTestHarness)this.testHarness).getEngine();
        this.dataCollector = engine.getBucketGraph();
        AppConfig.getsConfig().setTimezone(TimeZone.getTimeZone("Australia/Sydney"));
        this.dataCollector.reindex(engine.getLinecountCalculator(), engine.getStatus());
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testBranchLoc() throws Exception {
        BucketData buckets = this.getBuckets("__TRUNKLIKE__", Path.ROOT);
        Assert.assertTrue((String)"disabled for the moment", (boolean)true);
    }

    private void checkBuckets(String branch, Path path, String expectedBuckets) throws DbException {
        ParameterSetQuery params = new ParameterSetQuery();
        params.setBranch(branch);
        params.setPath(path);
        BucketDataCollectionTotalled buckets = this.dataCollector.getBuckets(params);
        Assert.assertEquals((Object)expectedBuckets, (Object)buckets.getFirst().toString());
    }

    private BucketData getBuckets(String branch, Path path) throws DbException {
        ParameterSetQuery params = new ParameterSetQuery();
        params.setBranch(branch);
        params.setPath(path);
        BucketDataCollectionTotalled buckets = this.dataCollector.getBuckets(params);
        return buckets.getFirst();
    }
}

