/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg;

import com.atlassian.fisheye.hg.HgCache;
import com.atlassian.fisheye.hg.HgSlurpTestBase;
import com.atlassian.fisheye.hg.db.HgRevInfo;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RevInfoKey;
import org.junit.Assert;
import org.junit.Test;

public class HgBinaryFileMergeChoosingParent0
extends HgSlurpTestBase {
    public HgBinaryFileMergeChoosingParent0() {
        super("binary-merge-choosing-parent0");
    }

    @Test
    public void testFileIsMarkedAsBinary() throws DbException {
        this.assertMergedFileIsMarkedAsBinary();
        this.assertCopiedBinaryFileIsMarkedAsBinary();
        this.assertMovedBinaryFileIsMarkedAsBinary();
    }

    public void assertCopiedBinaryFileIsMarkedAsBinary() throws DbException {
        HgRevInfo revInfo = (HgRevInfo)((HgCache)this.getCache()).getFileRevision(new RevInfoKey(new Path((CharSequence)"file2.pdf"), "59990535e658918fab421732056293308d99988e"));
        this.assertIsBinary(revInfo);
    }

    public void assertMovedBinaryFileIsMarkedAsBinary() throws DbException {
        HgRevInfo revInfo = (HgRevInfo)((HgCache)this.getCache()).getFileRevision(new RevInfoKey(new Path((CharSequence)"file1.pdf"), "f4bbc100da70aa0538803052ee4636811b054446"));
        this.assertIsBinary(revInfo);
    }

    public void assertMergedFileIsMarkedAsBinary() throws DbException {
        HgRevInfo revInfo = (HgRevInfo)((HgCache)this.getCache()).getFileRevision(new RevInfoKey(new Path((CharSequence)"file.pdf"), "851ee4d541537630a5b0b4871c0fefb965568cf6"));
        this.assertIsBinary(revInfo);
    }

    public void assertIsBinary(HgRevInfo revInfo) {
        Assert.assertNotNull((Object)revInfo);
        Assert.assertTrue((String)"File should be marked as binary", (boolean)revInfo.isBinary());
    }
}

