/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg;

import com.atlassian.fisheye.dvcs.DvcsRepoValidation;
import com.atlassian.fisheye.hg.HgCache;
import com.atlassian.fisheye.hg.HgSlurpTestBase;
import com.atlassian.fisheye.rep.RevCountChecker;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.Blame;
import com.cenqua.fisheye.rep.BlameChunk;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class HgBasicSlurpTest
extends HgSlurpTestBase {
    public HgBasicSlurpTest() {
        super("basic");
    }

    @Override
    protected int getBlockSize() {
        return 2;
    }

    @Test
    public void testBasicSlurp() throws DbException, IOException {
        this.assertCommitData(DvcsRepoValidation.Commits.first("6befb7b0fa111bb49c4dec9f74f624992ae02fbe", "alpha", "First Commit", "default", 1269658640000L, 1).next("a8b9fb6c14a45fb2e60ad8b7faa253a7f1a07f23", "6befb7b0fa111bb49c4dec9f74f624992ae02fbe", "alpha", "Second commit", "default", 1269658709000L, 2).l());
        this.assertRevisionData(DvcsRepoValidation.FileRevs.file("file1.txt").rev("6befb7b0fa111bb49c4dec9f74f624992ae02fbe", null, null, "alpha", "First Commit", 1269658640000L, "default", DvcsRepoValidation.RevState.Added, "file1.txt", false, 1, 1, 0).rev("a8b9fb6c14a45fb2e60ad8b7faa253a7f1a07f23", "6befb7b0fa111bb49c4dec9f74f624992ae02fbe", null, "alpha", "Second commit", 1269658709000L, "default", DvcsRepoValidation.RevState.Modified, "file1.txt", false, 2, 1, 0));
        this.assertRevisionData(DvcsRepoValidation.FileRevs.file("file2.txt").rev("a8b9fb6c14a45fb2e60ad8b7faa253a7f1a07f23", null, null, "alpha", "Second commit", 1269658709000L, "default", DvcsRepoValidation.RevState.Added, "file2.txt", false, 1, 1, 0));
        this.contentTest();
        this.blameTest();
        this.changesetRevCountTest();
    }

    private void changesetRevCountTest() {
        RevCountChecker.checkRevCounts(this.getCache());
    }

    private void blameTest() throws DbException, IOException {
        Path path = new Path((CharSequence)"file1.txt");
        FileHistory f1History = ((HgCache)this.getCache()).getFileHistory(path);
        FileRevision rev = f1History.getRevision("a8b9fb6c14a45fb2e60ad8b7faa253a7f1a07f23");
        RevInfoKey key = rev.getRevInfoKey();
        Blame blame = ((HgCache)this.getCache()).getBlame(key);
        List chunks = blame.getChunks();
        Assert.assertNotNull((Object)chunks);
        Assert.assertEquals((long)2L, (long)chunks.size());
        Assert.assertEquals((Object)"6befb7b0fa111bb49c4dec9f74f624992ae02fbe", (Object)((BlameChunk)chunks.get(0)).getRevision());
        Assert.assertEquals((Object)"a8b9fb6c14a45fb2e60ad8b7faa253a7f1a07f23", (Object)((BlameChunk)chunks.get(1)).getRevision());
    }

    private void contentTest() throws DbException, IOException {
        String rev0Content = "This is an initial test file\n";
        String rev1Content = "This is an initial test file\nnow I've added some more text\n";
        FileHistory history = ((HgCache)this.getCache()).getFileHistory(new Path((CharSequence)"file1.txt"));
        RevInfoKey key0 = history.getRevision("6befb7b0fa111bb49c4dec9f74f624992ae02fbe").getRevInfoKey();
        RevInfoKey key1 = history.getRevision("a8b9fb6c14a45fb2e60ad8b7faa253a7f1a07f23").getRevInfoKey();
        Assert.assertEquals((Object)rev0Content, (Object)this.getTextContent(key0));
        Assert.assertEquals((Object)rev1Content, (Object)this.getTextContent(key1));
    }

    private String getTextContent(RevInfoKey key) throws DbException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ((HgCache)this.getCache()).getTextRevision(key, (OutputStream)baos, null, null);
        Charset encoding = ((HgCache)this.getCache()).getTextEncoding(key);
        return new String(baos.toByteArray(), encoding.displayName());
    }
}

