/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg;

import com.atlassian.fisheye.bucket.BucketData;
import com.atlassian.fisheye.bucket.BucketDataCollectionTotalled;
import com.atlassian.fisheye.bucket.BucketGraph;
import com.atlassian.fisheye.bucket.ParameterSetQuery;
import com.atlassian.fisheye.hg.HgTestBase;
import com.atlassian.fisheye.hg.HgTestHarness;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import org.junit.Assert;
import org.junit.Before;

public abstract class HgAnonBranchLocTestBase
extends HgTestBase {
    BucketGraph dataCollector;

    public abstract String getDumpName();

    @Before
    public void setUp() throws Exception {
        this.slurpDump(this.getDumpName());
        Object engine = ((HgTestHarness)this.testHarness).getEngine();
        this.dataCollector = engine.getBucketGraph();
        this.dataCollector.reindex(engine.getLinecountCalculator(), engine.getStatus());
    }

    private void checkBuckets(String branch, Path path, String expectedBuckets) throws DbException {
        ParameterSetQuery params = new ParameterSetQuery();
        params.setBranch(branch);
        params.setPath(path);
        BucketDataCollectionTotalled buckets = this.dataCollector.getBuckets(params);
        Assert.assertEquals((Object)expectedBuckets, (Object)buckets.getFirst().toString());
    }

    public BucketData getBuckets(String branch, Path path) throws DbException {
        ParameterSetQuery params = new ParameterSetQuery();
        params.setBranch(branch);
        params.setPath(path);
        BucketDataCollectionTotalled buckets = this.dataCollector.getBuckets(params);
        return buckets.getFirst();
    }
}

