/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg;

import com.atlassian.fisheye.bucket.BucketData;
import com.atlassian.fisheye.bucket.BucketDataCollectionTotalled;
import com.atlassian.fisheye.bucket.BucketGraph;
import com.atlassian.fisheye.bucket.ParameterSetQuery;
import com.atlassian.fisheye.hg.HgRepositoryEngine;
import com.atlassian.fisheye.hg.HgTestBase;
import com.atlassian.fisheye.hg.HgTestHarness;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AnonBranchLocTest
extends HgTestBase {
    private BucketGraph dataCollector;

    @Before
    public void setUp() throws Exception {
        this.slurpDump("test-anon-branch-loc3");
        HgRepositoryEngine engine = (HgRepositoryEngine)((HgTestHarness)this.testHarness).getEngine();
        this.dataCollector = engine.getBucketGraph();
        this.dataCollector.reindex(engine.getLinecountCalculator(), engine.getStatus());
    }

    @Test
    public void testBranchLoc() throws Exception {
        BucketData buckets = this.getBuckets("__TRUNKLIKE__", Path.ROOT);
        BucketData buckets0 = this.getBuckets("__TRUNKLIKE__", new Path((CharSequence)"file0.txt"));
        BucketData buckets1 = this.getBuckets("__TRUNKLIKE__", new Path((CharSequence)"file1.txt"));
        System.out.println("buckets: " + buckets);
        System.out.println("buckets0: " + buckets0);
        System.out.println("buckets1: " + buckets1);
    }

    private void checkBuckets(String branch, Path path, String expectedBuckets) throws DbException {
        ParameterSetQuery params = new ParameterSetQuery();
        params.setBranch(branch);
        params.setPath(path);
        BucketDataCollectionTotalled buckets = this.dataCollector.getBuckets(params);
        Assert.assertEquals((Object)expectedBuckets, (Object)buckets.getFirst().toString());
    }

    private BucketData getBuckets(String branch, Path path) throws DbException {
        ParameterSetQuery params = new ParameterSetQuery();
        params.setBranch(branch);
        params.setPath(path);
        BucketDataCollectionTotalled buckets = this.dataCollector.getBuckets(params);
        return buckets.getFirst();
    }
}

