/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.gravatar;

import com.atlassian.fisheye.gravatar.MersenneTwister;
import com.cenqua.fisheye.util.MD5;
import junit.framework.TestCase;

public class MersenneTwisterTest
extends TestCase {
    public void testReproducability() {
        MersenneTwister rnd = new MersenneTwister(MD5.hexDecode((String)"3b3be63a4c2a439b013787725dfce802"));
        MersenneTwisterTest.assertEquals((int)0, (int)rnd.nextInt(16));
        MersenneTwisterTest.assertEquals((int)0, (int)rnd.nextInt(3));
        MersenneTwisterTest.assertEquals((int)0, (int)rnd.nextInt(3));
        MersenneTwisterTest.assertEquals((int)2, (int)rnd.nextInt(4));
        MersenneTwisterTest.assertEquals((int)0, (int)rnd.nextInt(4));
        MersenneTwisterTest.assertEquals((int)1, (int)rnd.nextInt(4));
        MersenneTwisterTest.assertEquals((int)2, (int)rnd.nextInt(4));
        rnd = new MersenneTwister(new byte[]{1, 2, 3});
        MersenneTwisterTest.assertEquals((int)9, (int)rnd.nextInt(16));
        MersenneTwisterTest.assertEquals((int)0, (int)rnd.nextInt(3));
        MersenneTwisterTest.assertEquals((int)1, (int)rnd.nextInt(3));
        MersenneTwisterTest.assertEquals((int)2, (int)rnd.nextInt(4));
        MersenneTwisterTest.assertEquals((int)1, (int)rnd.nextInt(4));
        MersenneTwisterTest.assertEquals((int)2, (int)rnd.nextInt(4));
        MersenneTwisterTest.assertEquals((int)3, (int)rnd.nextInt(4));
    }

    public void testUniformDistribution() {
        int[] hist16 = new int[16];
        int[] hist4 = new int[4];
        int[] hist3 = new int[3];
        int N = 10000;
        for (int i = 0; i < N; ++i) {
            MersenneTwister rnd = new MersenneTwister(MD5.hashAsBytes((String)(i + "@example.com")));
            int n = rnd.nextInt(16);
            hist16[n] = hist16[n] + 1;
            int n2 = rnd.nextInt(3);
            hist3[n2] = hist3[n2] + 1;
            int n3 = rnd.nextInt(3);
            hist3[n3] = hist3[n3] + 1;
            int n4 = rnd.nextInt(4);
            hist4[n4] = hist4[n4] + 1;
            int n5 = rnd.nextInt(4);
            hist4[n5] = hist4[n5] + 1;
            int n6 = rnd.nextInt(4);
            hist4[n6] = hist4[n6] + 1;
            int n7 = rnd.nextInt(4);
            hist4[n7] = hist4[n7] + 1;
        }
        MersenneTwisterTest.assertUniform(hist16, N);
        MersenneTwisterTest.assertUniform(hist3, N * 2);
        MersenneTwisterTest.assertUniform(hist4, N * 4);
    }

    private static void assertUniform(int[] hist, int N) {
        double n = (double)N / (double)hist.length;
        double d = n * 0.1;
        int low = (int)(n - d);
        int high = (int)(n + d);
        for (int i = 0; i < hist.length; ++i) {
            int v = hist[i];
            MersenneTwisterTest.assertTrue((String)(v + " vs " + low + " at " + i), (v >= low ? 1 : 0) != 0);
            MersenneTwisterTest.assertTrue((String)(v + " vs " + high + " at " + i), (v <= high ? 1 : 0) != 0);
        }
    }
}

