/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.gravatar;

import com.atlassian.fisheye.gravatar.AvatarManagerTest;
import com.atlassian.fisheye.gravatar.ImageUtils;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ImageUtilsTest {
    private static BufferedImage testJPGImage;
    private static BufferedImage testTallImage;
    private static BufferedImage testWideImage;

    @BeforeClass
    public static void beforeClass() throws Exception {
        testJPGImage = ImageIO.read(AvatarManagerTest.class.getResourceAsStream("images/default.jpg"));
        testTallImage = ImageIO.read(AvatarManagerTest.class.getResourceAsStream("images/tall.jpg"));
        testWideImage = ImageIO.read(AvatarManagerTest.class.getResourceAsStream("images/wide.jpg"));
    }

    @Test
    public void testCrop() throws Exception {
        int initialHeight = testJPGImage.getHeight();
        int initialWidth = testJPGImage.getWidth();
        BufferedImage croppedImage = ImageUtils.crop((BufferedImage)testJPGImage);
        Assert.assertEquals((String)"height of image should be unchanged", (long)initialHeight, (long)croppedImage.getHeight());
        Assert.assertEquals((String)"width of image should be unchanged", (long)initialWidth, (long)croppedImage.getWidth());
        Assert.assertEquals((String)"width and height of image should be equal", (long)croppedImage.getHeight(), (long)croppedImage.getWidth());
        initialHeight = testTallImage.getHeight();
        initialWidth = testTallImage.getWidth();
        croppedImage = ImageUtils.crop((BufferedImage)testTallImage);
        Assert.assertTrue((String)"height of image should be smaller", (initialHeight > croppedImage.getHeight() ? 1 : 0) != 0);
        Assert.assertEquals((String)"width of image should be unchanged", (long)initialWidth, (long)croppedImage.getWidth());
        Assert.assertEquals((String)"width and height of image should be equal", (long)croppedImage.getHeight(), (long)croppedImage.getWidth());
        initialHeight = testWideImage.getHeight();
        initialWidth = testWideImage.getWidth();
        croppedImage = ImageUtils.crop((BufferedImage)testWideImage);
        Assert.assertEquals((String)"height of image should be unchanged", (long)initialHeight, (long)croppedImage.getHeight());
        Assert.assertTrue((String)"width of image should be smaller", (initialWidth > croppedImage.getWidth() ? 1 : 0) != 0);
        Assert.assertEquals((String)"width and height of image should be equal", (long)croppedImage.getHeight(), (long)croppedImage.getWidth());
    }
}

