/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.gravatar;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.gravatar.AvatarTypeInfo;
import com.atlassian.fisheye.util.MockConfigParameters;
import com.atlassian.fisheye.util.UseTestSpringContextTestCase;
import com.cenqua.fisheye.config.ConfigParameters;
import com.cenqua.fisheye.config1.AvatarType;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.MD5;
import org.mockito.Mockito;

public class AvatarTypeInfoTest
extends UseTestSpringContextTestCase {
    private AvatarTypeInfo avatarTypeInfo;
    private AvatarType avatarType;
    private FecruUser user;
    private String emailHash;
    private UserManager userManager;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.userManager = (UserManager)Mockito.mock(UserManager.class);
        this.avatarTypeInfo = new AvatarTypeInfo((ConfigParameters)new MockConfigParameters());
        this.avatarType = this.avatarTypeInfo.getAvatarType();
        String username = "matt";
        String email = "matt@example.com";
        this.user = (FecruUser)Mockito.mock(FecruUser.class);
        Mockito.when((Object)this.user.getUsername()).thenReturn((Object)"matt");
        Mockito.when((Object)this.user.getEmail()).thenReturn((Object)"matt@example.com");
        this.emailHash = MD5.hash((String)"matt@example.com");
    }

    @Override
    public void tearDown() throws Exception {
        this.avatarTypeInfo = null;
        this.avatarType = null;
        super.tearDown();
    }

    public void testSetType() throws Exception {
        this.avatarTypeInfo.setType(AvatarTypeInfo.Type.INTERNAL.name(), null, null);
        AvatarTypeInfoTest.assertTrue((String)"avatarType should be set to internal", (boolean)this.avatarType.isSetInternal());
        this.avatarTypeInfo.setType(AvatarTypeInfo.Type.EXTERNAL.name(), "http://www.gravatar.com/avatar/", "");
        AvatarTypeInfoTest.assertTrue((String)"avatarType should have URL set", (boolean)this.avatarType.isSetUrl());
        AvatarTypeInfoTest.assertFalse((String)"avatarType should not be set to internal", (boolean)this.avatarType.isSetInternal());
    }

    public void testIsInternal() throws Exception {
        this.avatarTypeInfo.setType(AvatarTypeInfo.Type.INTERNAL.name(), null, null);
        AvatarTypeInfoTest.assertTrue((String)"isInternal should return true", (boolean)this.avatarTypeInfo.isInternal());
        this.avatarTypeInfo.setType(AvatarTypeInfo.Type.EXTERNAL.name(), "http://www.gravatar.com/avatar/", "");
        AvatarTypeInfoTest.assertFalse((String)"isInternal should return false", (boolean)this.avatarTypeInfo.isInternal());
    }

    public void testIsExternal() throws Exception {
        this.avatarTypeInfo.setType(AvatarTypeInfo.Type.EXTERNAL.name(), "http://www.gravatar.com/avatar/", "");
        AvatarTypeInfoTest.assertTrue((String)"isExternal should return true", (boolean)this.avatarTypeInfo.isExternal());
        this.avatarTypeInfo.setType(AvatarTypeInfo.Type.INTERNAL.name(), null, null);
        AvatarTypeInfoTest.assertFalse((String)"isExternal should return false", (boolean)this.avatarTypeInfo.isExternal());
    }

    public void testGetUrl() throws Exception {
        this.avatarTypeInfo.setType(AvatarTypeInfo.Type.INTERNAL.name(), null, null);
        AvatarTypeInfoTest.assertTrue((String)"url should match patten", (boolean)this.avatarTypeInfo.getUrl().matches("http://.+/avatar/"));
        this.avatarTypeInfo.setType(AvatarTypeInfo.Type.EXTERNAL.name(), "", "");
        AvatarTypeInfoTest.assertTrue((String)"url should match patten", (boolean)this.avatarTypeInfo.getUrl().equals("http://www.gravatar.com/avatar/"));
        String avatarUrl = "http://www.mygravatarserver.org/avatar/";
        this.avatarTypeInfo.setType(AvatarTypeInfo.Type.EXTERNAL.name(), avatarUrl, "");
        AvatarTypeInfoTest.assertTrue((String)"url should match patten", (boolean)this.avatarTypeInfo.getUrl().equals(avatarUrl));
    }

    public void testGetAvatarUrl() throws Exception {
        int size = 60;
        boolean noCache = true;
        boolean deleted = false;
        boolean fullUrls = false;
        String url = AvatarTypeInfo.getAvatarUrl((FecruUser)this.user, (Integer)size, (boolean)noCache, (boolean)fullUrls, (boolean)deleted);
        AvatarTypeInfoTest.assertEquals((String)"url should be equal", (String)"/foo/avatar/matt?s=60&noCache=true", (String)url);
        url = AvatarTypeInfo.getAvatarUrl((FecruUser)this.user, (Integer)size, (boolean)noCache);
        AvatarTypeInfoTest.assertEquals((String)"url should be equal", (String)"/foo/avatar/matt?s=60&noCache=true", (String)url);
        url = AvatarTypeInfo.getAvatarUrl((FecruUser)this.user, null, (boolean)noCache);
        AvatarTypeInfoTest.assertEquals((String)"url should handle null size", (String)"/foo/avatar/matt?s=48&noCache=true", (String)url);
        noCache = false;
        deleted = true;
        fullUrls = false;
        url = AvatarTypeInfo.getAvatarUrl((FecruUser)this.user, (Integer)size, (boolean)noCache, (boolean)fullUrls, (boolean)deleted);
        AvatarTypeInfoTest.assertEquals((String)"url should be deleted url regardless of user param", (String)"/foo/avatar/deleted?s=60", (String)url);
        noCache = false;
        deleted = false;
        fullUrls = true;
        url = AvatarTypeInfo.getAvatarUrl((FecruUser)this.user, (Integer)size, (boolean)noCache, (boolean)fullUrls, (boolean)deleted);
        AvatarTypeInfoTest.assertEquals((String)"url should be deleted url regardless of user param", (String)"http://example.com/foo/avatar/matt?s=60", (String)url);
    }

    public void testGetDeletedAvatarUrl() throws Exception {
        String url = AvatarTypeInfo.getDeletedAvatarUrl((Integer)60);
        AvatarTypeInfoTest.assertEquals((String)"url should be deleted url", (String)"/foo/avatar/deleted?s=60", (String)url);
        url = AvatarTypeInfo.getDeletedAvatarUrl(null);
        AvatarTypeInfoTest.assertEquals((String)"url should be deleted url", (String)"/foo/avatar/deleted?s=48", (String)url);
    }

    public void testGetFullAvatarUrl() throws Exception {
        String url = AvatarTypeInfo.getFullAvatarUrl((FecruUser)this.user, (Integer)60);
        AvatarTypeInfoTest.assertEquals((String)"url should be deleted url", (String)"http://example.com/foo/avatar/matt?s=60", (String)url);
        url = AvatarTypeInfo.getFullAvatarUrl((FecruUser)this.user, null);
        AvatarTypeInfoTest.assertEquals((String)"url should be deleted url", (String)"http://example.com/foo/avatar/matt?s=48", (String)url);
    }

    public void testGetFallbackAvatarUrl() throws Exception {
        this.avatarTypeInfo.setType(AvatarTypeInfo.Type.INTERNAL.name(), null, null);
        String url = this.avatarTypeInfo.getExternalAvatarUrl(this.user, Integer.valueOf(60));
        AvatarTypeInfoTest.assertEquals((String)"urls should match", (String)"http://example.com/foo/avatar/702421acbcc8a345b3aaf090f6878814?s=60", (String)url);
        this.avatarTypeInfo.setType(AvatarTypeInfo.Type.EXTERNAL.name(), "http://www.mygravatarserver.org/", "");
        url = this.avatarTypeInfo.getExternalAvatarUrl(this.user, Integer.valueOf(60));
        AvatarTypeInfoTest.assertEquals((String)"urls should match", (String)("http://www.mygravatarserver.org/" + this.emailHash + "?s=60" + "&d=mm"), (String)url);
    }

    public void testInternalExternalPolicy() throws Exception {
        this.avatarTypeInfo.setType(AvatarTypeInfo.Type.INTERNAL.name(), null, null);
        String url = AvatarTypeInfo.getAvatarUrl((FecruUser)this.user, (Integer)60, (boolean)false, (boolean)true, (boolean)false);
        AvatarTypeInfoTest.assertEquals((String)"urls should match", (String)"http://example.com/foo/avatar/matt?s=60", (String)url);
        this.avatarTypeInfo.setType(AvatarTypeInfo.Type.EXTERNAL.name(), "http://www.mygravatarserver.org/", "");
        url = AvatarTypeInfo.getAvatarUrl((FecruUser)this.user, (Integer)60, (boolean)false, (boolean)true, (boolean)false);
        AvatarTypeInfoTest.assertEquals((String)"urls should match", (String)("http://www.mygravatarserver.org/" + this.emailHash + "?s=60" + "&d=mm"), (String)url);
        this.avatarTypeInfo.setType(AvatarTypeInfo.Type.EXTERNAL.name(), "http://www.mygravatarserver.org/", "d=identicon");
        url = AvatarTypeInfo.getAvatarUrl((FecruUser)this.user, (Integer)60, (boolean)false, (boolean)true, (boolean)false);
        AvatarTypeInfoTest.assertEquals((String)"urls should match", (String)("http://www.mygravatarserver.org/" + this.emailHash + "?s=60" + "&d=identicon"), (String)url);
    }
}

