/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.gravatar;

import com.atlassian.fisheye.gravatar.Avatar;
import java.awt.image.BufferedImage;
import java.io.File;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class AvatarTest {
    private static File testJPGImage;
    private static File testGIFImage;
    private static File testPNGImage;

    @BeforeClass
    public static void beforeClass() throws Exception {
        testJPGImage = new File(AvatarTest.class.getResource("images/default.jpg").toURI());
        testGIFImage = new File(AvatarTest.class.getResource("images/default.gif").toURI());
        testPNGImage = new File(AvatarTest.class.getResource("images/default.png").toURI());
    }

    @Test
    public void testGetContentType() throws Exception {
        Avatar avatar = new Avatar(testPNGImage);
        Assert.assertEquals((String)"contentType should be 'image/png'", (Object)"image/png", (Object)avatar.getContentType());
        avatar = new Avatar(testGIFImage);
        Assert.assertEquals((String)"contentType should be 'image/gif'", (Object)"image/gif", (Object)avatar.getContentType());
    }

    @Test
    public void testGetThumbnail() throws Exception {
        Avatar avatar = new Avatar(testJPGImage);
        BufferedImage thumbnail = avatar.getThumbnail(80);
        Assert.assertEquals((String)"height of image should be 80px", (long)80L, (long)thumbnail.getHeight());
        Assert.assertEquals((String)"width of image should be 80px", (long)80L, (long)thumbnail.getWidth());
        avatar = new Avatar(testGIFImage);
        thumbnail = avatar.getThumbnail(80);
        Assert.assertEquals((String)"height of image should be 80px", (long)80L, (long)thumbnail.getHeight());
        Assert.assertEquals((String)"width of image should be 80px", (long)80L, (long)thumbnail.getWidth());
        avatar = new Avatar(testPNGImage);
        thumbnail = avatar.getThumbnail(80);
        Assert.assertEquals((String)"height of image should be 80px", (long)80L, (long)thumbnail.getHeight());
        Assert.assertEquals((String)"width of image should be 80px", (long)80L, (long)thumbnail.getWidth());
        avatar = new Avatar(testJPGImage);
        thumbnail = avatar.getThumbnail(140);
        Assert.assertEquals((String)"height of image should be 140px", (long)140L, (long)thumbnail.getHeight());
        Assert.assertEquals((String)"width of image should be 140px", (long)140L, (long)thumbnail.getWidth());
        avatar = new Avatar(testGIFImage);
        thumbnail = avatar.getThumbnail(140);
        Assert.assertEquals((String)"height of image should be 140px", (long)140L, (long)thumbnail.getHeight());
        Assert.assertEquals((String)"width of image should be 140px", (long)140L, (long)thumbnail.getWidth());
        avatar = new Avatar(testPNGImage);
        thumbnail = avatar.getThumbnail(140);
        Assert.assertEquals((String)"height of image should be 140px", (long)140L, (long)thumbnail.getHeight());
        Assert.assertEquals((String)"width of image should be 140px", (long)140L, (long)thumbnail.getWidth());
    }
}

