/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.gravatar;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.gravatar.Avatar;
import com.atlassian.fisheye.gravatar.AvatarManager;
import com.atlassian.fisheye.gravatar.DefaultAvatarManager;
import com.cenqua.fisheye.AppConfig;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AvatarManagerTest {
    private File instanceDir;
    private FecruUser user;
    private File imageFile;
    private AvatarManager avatarManager;

    @Before
    public void setUp() throws Exception {
        this.instanceDir = AppConfig.getInstanceDir();
        AppConfig.overrideAppHome((File)AppConfig.getAppHome(), (File)new File(AppConfig.getAppHome(), "output/test/dist_inst"));
        this.avatarManager = new DefaultAvatarManager(null);
        this.user = new FecruUser("matt");
        this.imageFile = File.createTempFile("data", ".png");
        this.imageFile.deleteOnExit();
        BufferedImage image = new BufferedImage(200, 200, 1);
        Graphics g = image.getGraphics();
        g.setColor(Color.BLUE);
        g.fillOval(0, 0, 200, 200);
        ImageIO.write((RenderedImage)image, "PNG", this.imageFile);
    }

    @After
    public void tearDown() throws Exception {
        AppConfig.overrideAppHome((File)AppConfig.getAppHome(), (File)this.instanceDir);
    }

    @Test
    public void testSaveAvatar() throws Exception {
        this.avatarManager.saveAvatar(this.user, this.imageFile);
    }

    @Test
    public void testHasAvatar() throws Exception {
        this.avatarManager.saveAvatar(this.user, this.imageFile);
        Assert.assertTrue((String)"User should have avatar", (boolean)this.avatarManager.hasAvatar(this.user));
    }

    @Test
    public void testGetAvatar() throws Exception {
        this.avatarManager.saveAvatar(this.user, this.imageFile);
        Avatar avatar = this.avatarManager.getAvatar(this.user);
        Assert.assertNotSame((String)"image should not be null", null, (Object)avatar.getImage());
    }

    @Test
    public void testGetGenericAvatar() throws Exception {
        this.avatarManager.saveAvatar(this.user, this.imageFile);
        Avatar avatar = this.avatarManager.getGenericAvatar();
        Assert.assertNotSame((String)"image should not be null", null, (Object)avatar.getImage());
    }

    @Test
    public void testGetDeletedAvatar() throws Exception {
        this.avatarManager.saveAvatar(this.user, this.imageFile);
        Avatar avatar = this.avatarManager.getDeletedAvatar();
        Assert.assertNotSame((String)"image should not be null", null, (Object)avatar.getImage());
    }

    @Test
    public void testGetDefaultCharlatar() throws Exception {
        this.avatarManager.saveAvatar(this.user, this.imageFile);
        Avatar avatar = this.avatarManager.getDefaultCharlatar();
        Assert.assertNotSame((String)"image should not be null", null, (Object)avatar.getImage());
    }
}

