/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git.client;

import com.atlassian.fisheye.git.client.GitRemoteShowOutputHandler;
import com.atlassian.utils.process.ProcessException;
import com.atlassian.utils.process.Watchdog;
import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class GitRemoteShowOutputHandlerTest {
    private GitRemoteShowOutputHandler handler = new GitRemoteShowOutputHandler(Charsets.UTF_8);

    @Before
    public void setUp() throws Exception {
        this.handler.setWatchdog((Watchdog)Mockito.mock(Watchdog.class));
    }

    @Test
    public void shouldParseAmbiguousOutput() throws Exception {
        String ambiguousOutput = "* remote origin\n  Fetch URL: /testrepo/\n  Push  URL: /testrepo/\n  HEAD branch (remote HEAD is ambiguous, may be one of the following):\n    first\n    second\n  Remote branches:\n    first  tracked\n    second tracked\n  Local branch configured for 'git pull':\n    first merges with remote first\n  Local ref configured for 'git push':\n    first pushes to first (up to date)\n";
        String result = this.getHandlerResult(ambiguousOutput);
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)"first"));
    }

    @Test
    public void shouldProcessUnambiguousOutput() throws Exception {
        String shortOutput = "* remote git@bitbucket.org:lpater/test-git-nomaster.git\n  Fetch URL: git@bitbucket.org:lpater/test-git-nomaster.git\n  Push  URL: git@bitbucket.org:lpater/test-git-nomaster.git\n  HEAD branch: second\n";
        String result = this.getHandlerResult(shortOutput);
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)"second"));
    }

    @Test
    public void shouldProcessUnambiguousOutputWithExtraInfo() throws Exception {
        String longOutput = "* remote /tmp/CRC-7487/test.git\n  Fetch URL: /tmp/CRC-7487/test.git\n  Push  URL: /tmp/CRC-7487/test.git\n  HEAD branch: first\n  Local refs configured for 'git push':\n    first  pushes to first  (up to date)\n    second pushes to second (up to date)\n";
        String result = this.getHandlerResult(longOutput);
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)"first"));
    }

    @Test
    public void shouldReturnNullForUnknown() throws Exception {
        String shortOutput = "* remote git@bitbucket.org:lpater/test-git-nomaster.git\n  Fetch URL: git@bitbucket.org:lpater/test-git-nomaster.git\n  Push  URL: git@bitbucket.org:lpater/test-git-nomaster.git\n  HEAD branch: (unknown)\n";
        String result = this.getHandlerResult(shortOutput);
        Assert.assertThat((Object)result, (Matcher)Matchers.nullValue());
    }

    private String getHandlerResult(String output) throws ProcessException {
        this.handler.process((InputStream)new ByteArrayInputStream(output.getBytes(Charsets.UTF_8)));
        return this.handler.getResult();
    }
}

