/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git.client;

import com.atlassian.fisheye.git.client.GitListTreeOutputHandler;
import com.cenqua.fisheye.rep.GitTreeNode;
import java.nio.charset.Charset;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class GitListTreeOutputHandlerTest {
    private void assertGitTreeNodeEquals(GitTreeNode expected, GitTreeNode actual) {
        Assert.assertEquals((String)("Node names not equal.  Expected: " + expected.getName() + " Actual " + actual.getName()), (Object)expected.getName(), (Object)actual.getName());
        Assert.assertEquals((String)("Node hashes not equal.  Expected: " + expected.getNodeHash() + " Actual " + actual.getNodeHash()), (Object)expected.getNodeHash(), (Object)actual.getNodeHash());
        Assert.assertEquals((String)("Node types not equal.  Expected: " + expected.getNodeType() + " Actual " + actual.getNodeType()), (Object)expected.getNodeType(), (Object)actual.getNodeType());
        Assert.assertEquals((String)("Node permissions not equal.  Expected: " + expected.getPermissions() + " Actual " + actual.getPermissions()), (Object)expected.getPermissions(), (Object)actual.getPermissions());
    }

    private void testForLine(String line, GitTreeNode expected) {
        GitListTreeOutputHandler handler = new GitListTreeOutputHandler(Charset.defaultCharset(), "test");
        handler.processLine(1, line);
        Set nodes = handler.getTreeNodes();
        Assert.assertEquals((String)("Expected only one object in tree output, got " + nodes.size()), (long)1L, (long)nodes.size());
        this.assertGitTreeNodeEquals(expected, (GitTreeNode)nodes.iterator().next());
    }

    @Test
    public void testSimpleTreeNode() {
        this.testForLine("100644 blob 88dd7f9324f898b9318ef8b68b5fdbd081833b22\tTestIdeaWebApp.ipr", new GitTreeNode("100644", GitTreeNode.Type.BLOB, "88dd7f9324f898b9318ef8b68b5fdbd081833b22", "TestIdeaWebApp.ipr"));
    }

    @Test
    public void testSubtreeNode() {
        this.testForLine("040000 tree 522a4dc13fed5e274769dbaaa412c5e0b8a6c738\tweb", new GitTreeNode("040000", GitTreeNode.Type.TREE, "522a4dc13fed5e274769dbaaa412c5e0b8a6c738", "web"));
    }

    @Test
    public void testSubdirectoryNode() {
        this.testForLine("100644 blob 132473ff12617ce422a70dd456bb47c12c4fb055\tweb/index.jsp", new GitTreeNode("100644", GitTreeNode.Type.BLOB, "132473ff12617ce422a70dd456bb47c12c4fb055", "web/index.jsp"));
    }
}

