/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git.client;

import com.atlassian.fisheye.git.client.GitListBranchesOutputHandler;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.BranchState;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GitListBranchesOutputHandlerTest {
    private GitListBranchesOutputHandler handler;
    private Set<Branch> branches;

    @Before
    public void createHandler() {
        this.branches = Sets.newHashSet();
        this.handler = new GitListBranchesOutputHandler("UTF-8"){

            protected void processBranch(Branch branch) {
                GitListBranchesOutputHandlerTest.this.branches.add(branch);
            }
        };
    }

    protected void testForLine(String line, String name, String lastChangeSetId, BranchState state) {
        this.handler.processLine(1, line);
        Assert.assertThat(this.branches, (Matcher)Matchers.contains(GitListBranchesOutputHandlerTest.matchesBranch(name, lastChangeSetId, state)));
    }

    @Test
    public void testBranch() {
        this.testForLine("72f79ef5722ff839ba6f69258869f9cfaf094f94 refs/heads/0.24.release", "0.24.release", "72f79ef5722ff839ba6f69258869f9cfaf094f94", BranchState.ACTIVE);
    }

    @Test
    public void testComplexBranch() {
        this.testForLine("f1ff0ca4c82efa6b14b290e549ca3425d619e007 refs/heads/issue-0.25/AO-526-fix-PostgresQueryTest", "issue-0.25/AO-526-fix-PostgresQueryTest", "f1ff0ca4c82efa6b14b290e549ca3425d619e007", BranchState.ACTIVE);
    }

    @Test
    public void testMasterBranch() {
        this.testForLine("de169fdfa1498049f4c3b7731b53a5de16144a75 refs/heads/master", "master", "de169fdfa1498049f4c3b7731b53a5de16144a75", BranchState.ACTIVE);
    }

    @Test
    public void testFullCommand() throws Exception {
        String[] inputLines = new String[]{"72f79ef5722ff839ba6f69258869f9cfaf094f94 refs/heads/0.24.release", "f1ff0ca4c82efa6b14b290e549ca3425d619e007 refs/heads/issue-0.25/AO-526-fix-PostgresQueryTest", "de169fdfa1498049f4c3b7731b53a5de16144a75 refs/heads/master", "54c2855501537a208ce2c15b22165d76403c734c refs/heads/issue/AO-526"};
        int lineNo = 0;
        for (String inputLine : inputLines) {
            this.handler.processLine(lineNo++, inputLine);
        }
        Assert.assertThat(this.branches, (Matcher)Matchers.containsInAnyOrder((Collection)new ImmutableList.Builder().add(GitListBranchesOutputHandlerTest.matchesBranch("issue/AO-526", "54c2855501537a208ce2c15b22165d76403c734c", BranchState.ACTIVE)).add(GitListBranchesOutputHandlerTest.matchesBranch("0.24.release", "72f79ef5722ff839ba6f69258869f9cfaf094f94", BranchState.ACTIVE)).add(GitListBranchesOutputHandlerTest.matchesBranch("issue-0.25/AO-526-fix-PostgresQueryTest", "f1ff0ca4c82efa6b14b290e549ca3425d619e007", BranchState.ACTIVE)).add(GitListBranchesOutputHandlerTest.matchesBranch("master", "de169fdfa1498049f4c3b7731b53a5de16144a75", BranchState.ACTIVE)).build()));
    }

    private static Matcher<Branch> matchesBranch(final String name, final String lastChangeSetId, final BranchState state) {
        return new TypeSafeMatcher<Branch>(){

            protected boolean matchesSafely(Branch actualBranch) {
                return Objects.equal((Object)actualBranch.getName(), (Object)name) && Objects.equal((Object)actualBranch.getState(), (Object)state) && Objects.equal((Object)actualBranch.getLatestChangeSetId(), (Object)lastChangeSetId);
            }

            public void describeTo(Description description) {
                description.appendText("name: ").appendValue((Object)name).appendText(", state: ").appendValue((Object)state).appendText(", lastChangeSetId: ").appendValue((Object)lastChangeSetId);
            }
        };
    }
}

