/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git.client;

import com.atlassian.fisheye.git.client.GitEscape;
import java.text.ParsePosition;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class GitEscapeTest {
    @Test
    public void testDoSingleGitEscape() throws Exception {
        Assert.assertThat((String)"\\n properly escaped", (Object)Character.valueOf(this.testDoSingleGitEscape("abc\\n", 4)), (Matcher)CoreMatchers.is((Object)Character.valueOf('\n')));
        Assert.assertThat((String)"\\t properly escaped", (Object)Character.valueOf(this.testDoSingleGitEscape("abc\\t", 4)), (Matcher)CoreMatchers.is((Object)Character.valueOf('\t')));
        Assert.assertThat((String)"\\\" properly escaped", (Object)Character.valueOf(this.testDoSingleGitEscape("abc\\\"", 4)), (Matcher)CoreMatchers.is((Object)Character.valueOf('\"')));
        Assert.assertThat((String)"\\\\ properly escaped", (Object)Character.valueOf(this.testDoSingleGitEscape("abc\\\\", 4)), (Matcher)CoreMatchers.is((Object)Character.valueOf('\\')));
        Assert.assertThat((String)"\\001 properly escaped", (Object)Character.valueOf(this.testDoSingleGitEscape("abc\\001", 4)), (Matcher)CoreMatchers.is((Object)Character.valueOf('\u0001')));
        Assert.assertThat((String)"\\02 properly escaped", (Object)Character.valueOf(this.testDoSingleGitEscape("abc\\028", 4)), (Matcher)CoreMatchers.is((Object)Character.valueOf('\u0002')));
        Assert.assertThat((String)"\\3 properly escaped", (Object)Character.valueOf(this.testDoSingleGitEscape("abc\\3", 4)), (Matcher)CoreMatchers.is((Object)Character.valueOf('\u0003')));
        Assert.assertThat((String)"\\14 properly escaped", (Object)Character.valueOf(this.testDoSingleGitEscape("abc\\14", 4)), (Matcher)CoreMatchers.is((Object)Character.valueOf('\f')));
        Assert.assertThat((String)"unrecognised escape combination has backslash stripped", (Object)Character.valueOf(this.testDoSingleGitEscape("abc\\e", 4)), (Matcher)CoreMatchers.is((Object)Character.valueOf('e')));
        Assert.assertThat((String)"\\ followed by nothing left intact", (Object)Character.valueOf(this.testDoSingleGitEscape("abc\\", 4)), (Matcher)CoreMatchers.is((Object)Character.valueOf('\\')));
        Assert.assertThat((String)"\\r properly escaped", (Object)Character.valueOf(this.testDoSingleGitEscape("abc\\r", 4)), (Matcher)CoreMatchers.is((Object)Character.valueOf('\r')));
    }

    private char testDoSingleGitEscape(String gitString, int index) {
        return GitEscape.doSingleGitEscape((String)gitString, (ParsePosition)new ParsePosition(index));
    }
}

