/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git.client;

import com.atlassian.fisheye.git.client.GitDiffInfo;
import com.atlassian.fisheye.git.client.GitDiffOutputHandler;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.rep.DiffTextCache;
import com.cenqua.fisheye.rep.RepositoryStatus;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class GitDiffOutputHandlerTest {
    private List<GitDiffInfo> parseDiff(InputStream diffInputStream) throws IOException {
        final ArrayList<GitDiffInfo> results = new ArrayList<GitDiffInfo>();
        GitDiffOutputHandler parser = new GitDiffOutputHandler(new RepositoryStatus("test"), Charset.forName("UTF8"), new DiffTextCache("test", false)){

            protected void processDiffInfo(GitDiffInfo diffInfo) {
                results.add(diffInfo);
            }
        };
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(diffInputStream));){
            String line;
            int lineNum = 0;
            while ((line = reader.readLine()) != null) {
                parser.processLine(++lineNum, line);
            }
        }
        parser.complete();
        return results;
    }

    private List<GitDiffInfo> parseDiff(String diffFile) throws IOException {
        return this.parseDiff(this.getClass().getResourceAsStream(diffFile));
    }

    private List<GitDiffInfo> parseCopyDiff(String fromFileName, boolean fromQuoted, String toFileName, boolean toQuoted) throws IOException {
        String fromQuote = fromQuoted ? "\"" : "";
        String toQuote = toQuoted ? "\"" : "";
        String diff = "diff --git " + fromQuote + "a/" + fromFileName + fromQuote + " " + toQuote + "b/" + toFileName + toQuote + "\n" + "old mode 100644\n" + "new mode 100755\n" + "similarity index 100%\n" + "copy from " + fromFileName + "\n" + "copy to " + toFileName;
        return this.parseDiff(new ByteArrayInputStream(diff.getBytes()));
    }

    private void assertHunks(GitDiffInfo actual, Hunk ... expectedHunks) {
        Assert.assertNotNull((Object)actual);
        List actualHunks = actual.getHunks();
        if (actualHunks != null) {
            Iterator actualIt = actualHunks.iterator();
            Assert.assertEquals((long)expectedHunks.length, (long)actualHunks.size());
            for (Hunk expected : expectedHunks) {
                Assert.assertEquals((Object)expected, actualIt.next());
            }
        } else {
            Assert.assertEquals((long)expectedHunks.length, (long)0L);
        }
    }

    @Test
    public void testDiffWithWindowsStyleEOL() throws IOException {
        List<GitDiffInfo> results = this.parseDiff("gitdiff-windows-eol.txt");
        Assert.assertEquals((long)2L, (long)results.size());
        this.assertHunks(results.get(0), new Hunk(1, 1, 1, 316));
        this.assertHunks(results.get(1), new Hunk(1660, 1660, 4, 4));
    }

    @Test
    public void testStraightDiff() throws IOException {
        List<GitDiffInfo> results = this.parseDiff("gitdiff-regular.txt");
        Assert.assertEquals((long)6L, (long)results.size());
        this.assertHunks(results.get(0), new Hunk(1, 0, 1058, 0));
        this.assertHunks(results.get(1), new Hunk[0]);
        this.assertHunks(results.get(2), new Hunk(1, 0, 1290, 0));
        this.assertHunks(results.get(3), new Hunk[0]);
        this.assertHunks(results.get(4), new Hunk(3, 2, 2, 0), new Hunk(22, 20, 1, 1), new Hunk(26, 25, 0, 4));
        this.assertHunks(results.get(5), new Hunk(44, 45, 0, 4));
    }

    @Test
    public void testCopyBothNamesUnquoted() throws IOException {
        List<GitDiffInfo> results = this.parseCopyDiff("left.txt", false, "right.txt", false);
        Assert.assertThat(results, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)results.get(0).isCopy(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)results.get(0).getFromPath(), (Matcher)Is.is((Object)"left.txt"));
        Assert.assertThat((Object)results.get(0).getToPath(), (Matcher)Is.is((Object)"right.txt"));
    }

    @Test
    public void testCopyFromFileQuoted() throws IOException {
        List<GitDiffInfo> results = this.parseCopyDiff("left.txt", true, "right.txt", false);
        Assert.assertThat(results, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)results.get(0).isCopy(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)results.get(0).getFromPath(), (Matcher)Is.is((Object)"left.txt"));
        Assert.assertThat((Object)results.get(0).getToPath(), (Matcher)Is.is((Object)"right.txt"));
    }

    @Test
    public void testCopyToFileQuoted() throws IOException {
        List<GitDiffInfo> results = this.parseCopyDiff("left.txt", false, "right.txt", true);
        Assert.assertThat(results, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)results.get(0).isCopy(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)results.get(0).getFromPath(), (Matcher)Is.is((Object)"left.txt"));
        Assert.assertThat((Object)results.get(0).getToPath(), (Matcher)Is.is((Object)"right.txt"));
    }

    @Test
    public void testCopyBothNamesQuoted() throws IOException {
        List<GitDiffInfo> results = this.parseCopyDiff("left.txt", true, "right.txt", true);
        Assert.assertThat(results, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)results.get(0).isCopy(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)results.get(0).getFromPath(), (Matcher)Is.is((Object)"left.txt"));
        Assert.assertThat((Object)results.get(0).getToPath(), (Matcher)Is.is((Object)"right.txt"));
    }
}

