/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git.client;

import com.atlassian.fisheye.git.client.GitBlameParser;
import com.cenqua.fisheye.rep.DbException;
import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class GitBlameParserTest {
    @Test
    public void testParser() throws Exception {
        String line;
        ImmutableList expected = ImmutableList.builder().add((Object[])new Object[][]{{"61e37d41490aed319a176c6ca7feb95e5505059c", "src/queue.js", 25, 21, 1}, {"2b70893928035d53f46575003197e4a1fa52a844", "src/queue.js", 68, 22, 2}, {"fb48ae8e6cca25fd29ef2b1eb23e9efa7b0eef7c", "src/queue.js", 30, 24, 1}, {"3812f9436da09d9f31ca4a61a14cd70f3e8cbeaf", "src/queue.js", 25, 25, 1}, {"a3b59d7f92c9e15af1888fc4e87639a290763a50", "src/queue.js", 73, 26, 1}, {"4621a0131b98461e41082aa0aaf73f9c6f4ca9ce", "src/queue.js", 28, 27, 4}, {"ebad701751689b773afe29d1e3c4532c7810d02a", "src/queue.js", 23, 31, 2}, {"61e37d41490aed319a176c6ca7feb95e5505059c", "src/queue.js", 31, 33, 2}}).build();
        TestGitBlameParser gitBlameParser = new TestGitBlameParser((List<Object[]>)expected);
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("gitblame.txt")));
        int lineNo = 0;
        while ((line = reader.readLine()) != null) {
            gitBlameParser.processLine(lineNo++, line);
        }
        Assert.assertEquals((String)"Too few chunks", (long)expected.size(), (long)gitBlameParser.chunkNum);
    }

    private static class TestGitBlameParser
    extends GitBlameParser {
        private final List<Object[]> expected;
        private int chunkNum = 0;

        public TestGitBlameParser(List<Object[]> expected) {
            super(Charset.forName("UTF8"));
            this.expected = expected;
        }

        protected void startChunk(String commit, String filename, int originalLine, int lineNum, int length) throws DbException {
            Assert.assertTrue((String)("More chunks than expected " + this.chunkNum), (this.expected.size() > this.chunkNum ? 1 : 0) != 0);
            Object[] expectedChunk = this.expected.get(this.chunkNum);
            Assert.assertEquals((String)("Wrong revision in chunk " + this.chunkNum), (Object)expectedChunk[0], (Object)commit);
            Assert.assertEquals((String)("Wrong filename in chunk " + this.chunkNum), (Object)expectedChunk[1], (Object)filename);
            Assert.assertEquals((String)("Wrong originalLine in chunk " + this.chunkNum), (Object)expectedChunk[2], (Object)originalLine);
            Assert.assertEquals((String)("Wrong lineNum in chunk " + this.chunkNum), (Object)expectedChunk[3], (Object)lineNum);
            Assert.assertEquals((String)("Wrong length in chunk " + this.chunkNum), (Object)expectedChunk[4], (Object)length);
            ++this.chunkNum;
        }
    }
}

