/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git;

import com.atlassian.fisheye.git.GitTestHarness;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import java.io.File;
import java.io.IOException;

class GitZippedCacheTestHarness
extends GitTestHarness {
    private final String cacheDumpFile;

    public GitZippedCacheTestHarness(String cacheDumpFile) {
        this.cacheDumpFile = cacheDumpFile;
    }

    @Override
    public void startRepo() {
        this.unzipCache(this.getAppDir(), this.getRepoName());
    }

    private void unzipCache(File appDir, String repoName) {
        try {
            File cacheDir = new File(appDir, "var/cache/" + repoName);
            System.out.println("Cache dir: " + cacheDir);
            IOHelper.mkdirs((File)cacheDir);
            String cacheZipName = this.cacheDumpFile;
            File cacheZip = new File(FisheyeTestEnv.WORKSPACE_DIR, cacheZipName);
            IOHelper.unzip((File)cacheZip, (File)cacheDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

