/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git;

import com.atlassian.fecru.upgrade.UpgradeManager;
import com.atlassian.fisheye.dvcs.DvcsTestHarness;
import com.atlassian.fisheye.git.GitRepositoryEngine;
import com.atlassian.fisheye.git.GitScanner;
import com.atlassian.fisheye.git.GitScmConfig;
import com.atlassian.fisheye.git.client.GitProcessFactory;
import com.atlassian.fisheye.scmapi.ScmConfig;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.GitConfigType;
import com.cenqua.fisheye.config1.GitRepType;
import com.cenqua.fisheye.config1.PasswordAuthenticationType;
import com.cenqua.fisheye.config1.RenameOptions;
import com.cenqua.fisheye.config1.RepositorySystemType;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.config1.SshKeyAuthenticationType;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.NullLicenseEnforcer;
import com.jcraft.jsch.JSchException;
import java.io.IOException;
import java.math.BigInteger;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlException;

public class GitTestHarness
extends DvcsTestHarness<GitRepositoryEngine, GitScanner> {
    private RenameOptions.Enum renameDetection;

    protected void setRenameDetection(RenameOptions.Enum renameDetection) {
        this.renameDetection = renameDetection;
    }

    protected RenameOptions.Enum getRenameDetection() {
        return this.renameDetection;
    }

    @Override
    protected GitRepositoryEngine createEngine() throws XmlException, IOException, ConfigException, DbException {
        RepositoryType repoDef;
        try {
            repoDef = this.createGitRepoDef();
        }
        catch (JSchException e) {
            throw new ConfigException((Throwable)e);
        }
        this.createServerConfig(this.getScmExecutable());
        GitScmConfig gitConfig = new GitScmConfig(repoDef.getName(), this.getRootConfig(), (RepositorySystemType)repoDef.getGit(), this.getSshKeyManager(), (GitProcessFactory)SpringContext.getComponentByClass(GitProcessFactory.class));
        NullLicenseEnforcer licenseEnforcer = new NullLicenseEnforcer();
        RepositoryConfig config = new RepositoryConfig(this.getRootConfig(), repoDef, (ScmConfig)gitConfig, (LicenseEnforcer)licenseEnforcer, null);
        UpgradeManager upgradeManager = (UpgradeManager)SpringContext.getComponent((String)"upgradeManager");
        return (GitRepositoryEngine)config.createRepositoryEngine(upgradeManager, this.getIndexingContext());
    }

    protected RepositoryType createGitRepoDef() throws IOException, XmlException, JSchException {
        PasswordAuthenticationType passwordAuth;
        RepositoryType repoDefinition = this.createRepoDefinition();
        GitRepType git = repoDefinition.addNewGit();
        if (StringUtils.isNotBlank((String)this.getLocation())) {
            git.setLocation(this.getLocation());
        } else {
            git.setLocation(this.getRepoDir().getAbsolutePath());
        }
        if (this.getSubPath() != null) {
            git.setPath(this.getSubPath());
        }
        if (this.getRenameDetection() != null) {
            git.setRenames(this.getRenameDetection());
        }
        if (this.getBlockSize() > 0L) {
            git.setBlocksize(BigInteger.valueOf(this.getBlockSize()));
        }
        if ((passwordAuth = this.createPasswordAuthDef()) != null) {
            git.setPasswordAuth(passwordAuth);
        } else {
            SshKeyAuthenticationType sshAuth = this.createSshAuthDef();
            if (sshAuth != null) {
                git.setSshAuth(sshAuth);
            }
        }
        return repoDefinition;
    }

    protected void createServerConfig(String gitExecutable) {
        ConfigDocument.Config serverConfig = this.getRootConfig().getConfig();
        serverConfig.setGitConfig(GitConfigType.Factory.newInstance());
        serverConfig.getGitConfig().setGitExecutable(gitExecutable);
    }
}

