/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git;

import com.atlassian.fisheye.dvcs.DvcsTestBase;
import com.atlassian.fisheye.git.GitCache;
import com.atlassian.fisheye.git.GitRepositoryEngine;
import com.atlassian.fisheye.git.GitScanner;
import com.atlassian.fisheye.git.GitTestHarness;
import com.atlassian.fisheye.git.db.GitChangeSet;
import com.atlassian.fisheye.git.db.GitRevInfo;
import com.atlassian.fisheye.git.db.GitStringTables;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config1.AllowType;
import com.cenqua.fisheye.config1.RenameOptions;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Before;

public abstract class GitTestBase
extends DvcsTestBase<GitTestHarness, GitRevInfo, GitChangeSet, GitCache, GitScanner, GitRepositoryEngine, GitStringTables> {
    private String dumpName;

    public GitTestBase() {
        super("test/testfiles/git/dumps/");
    }

    public GitTestBase(String dumpName) {
        this();
        this.dumpName = dumpName;
    }

    protected boolean isTestEnabled() {
        return true;
    }

    @Before
    public void slurpRepo() throws Exception {
        if (this.isTestEnabled()) {
            if (StringUtils.isNotBlank((String)this.dumpName)) {
                this.slurpDump(this.dumpName);
            }
        } else {
            Logs.APP_LOG.info((Object)("Skipping tests in test class " + this.getClass().getName()));
        }
    }

    @Override
    protected GitTestHarness createTestHarness() {
        GitTestHarness testHarness = this.createHarness();
        boolean storeDiffs = this.getStoreDiffs();
        testHarness.setSubPath(this.getSubPath());
        testHarness.setAllow(this.getAllowRules());
        testHarness.setStoreDiffs(storeDiffs);
        testHarness.setBlockSize(this.getBlockSize());
        testHarness.setRenameDetection(this.getRenameDetection());
        return testHarness;
    }

    protected GitTestHarness createHarness() {
        return new GitTestHarness(){

            @Override
            protected void afterEngineStarted() throws DbException {
                GitTestBase.this.engineStarted();
            }
        };
    }

    protected void engineStarted() {
    }

    @Override
    protected String findExecutable() throws IOException {
        String gitPathSysProp = System.getProperty("git.exe");
        if (!Strings.isNullOrEmpty((String)gitPathSysProp)) {
            return gitPathSysProp;
        }
        if (AppConfig.getsConfig().getConfigDocument() != null && AppConfig.getsConfig().getConfig() != null && AppConfig.getsConfig().getConfig().isSetGitConfig() && AppConfig.getsConfig().getConfig().getGitConfig().getGitExecutable() != null) {
            return AppConfig.getsConfig().getConfig().getGitConfig().getGitExecutable();
        }
        File gitExecutable = this.fileSystemUtils.searchPath(new String[]{"git", "git.exe"});
        if (gitExecutable != null) {
            return gitExecutable.getCanonicalPath();
        }
        List<String> possibleLocations = Arrays.asList("/usr/local/bin/git", "/opt/local/bin/git", "/usr/local/git/bin/git");
        for (String l : possibleLocations) {
            File git = new File(l);
            if (!git.exists()) continue;
            return git.getCanonicalPath();
        }
        Assert.fail((String)"Can't find git: you need to install git: http://git-scm.com");
        return null;
    }

    @Override
    protected int getBlockSize() {
        return -1;
    }

    @Override
    protected AllowType getAllowRules() {
        return null;
    }

    @Override
    protected String getSubPath() {
        return null;
    }

    @Override
    protected boolean getStoreDiffs() {
        return true;
    }

    protected RenameOptions.Enum getRenameDetection() {
        return RenameOptions.NONE;
    }
}

