/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git;

import com.atlassian.fisheye.StoppableVisitor;
import com.atlassian.fisheye.db.BranchDAO;
import com.atlassian.fisheye.dvcs.client.DvcsCommandBuilder;
import com.atlassian.fisheye.dvcs.db.DvcsRevInfo;
import com.atlassian.fisheye.dvcs.handler.DvcsProcessException;
import com.atlassian.fisheye.git.GitCache;
import com.atlassian.fisheye.git.GitRepositoryEngine;
import com.atlassian.fisheye.git.GitScanner;
import com.atlassian.fisheye.git.GitScmConfig;
import com.atlassian.fisheye.git.client.GitChangePath;
import com.atlassian.fisheye.git.client.GitCommandBuilder;
import com.atlassian.fisheye.git.client.GitCommitDetails;
import com.atlassian.fisheye.git.client.GitContext;
import com.atlassian.fisheye.git.db.GitChangeSetDAO;
import com.atlassian.fugue.Option;
import com.atlassian.utils.process.OutputHandler;
import com.atlassian.utils.process.ProcessHandler;
import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.IndexingConfig;
import com.cenqua.fisheye.config1.RenameOptions;
import com.cenqua.fisheye.crossrepo.BranchIndexer;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.rep.BlameAndLinecountCalculator;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.BranchState;
import com.cenqua.fisheye.rep.ChangeSetResolver;
import com.cenqua.fisheye.rep.CommonProperties;
import com.cenqua.fisheye.rep.IndexingContext;
import com.cenqua.fisheye.rep.IndexingState;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.google.common.math.IntMath;
import java.io.File;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class GitScannerTest {
    private Multimap<String, DvcsRevInfo> revisionsByHash;
    private List<String> blobInfos;
    private RepositoryConfig indexingConfigMock;
    private final GitRepositoryEngine engine = (GitRepositoryEngine)Mockito.mock(GitRepositoryEngine.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private GitContext ctx = (GitContext)Mockito.mock(GitContext.class);
    private final GitCache cache = (GitCache)Mockito.mock(GitCache.class);
    private GitChangeSetDAO changesetDao = (GitChangeSetDAO)Mockito.mock(GitChangeSetDAO.class);
    private final BranchDAO branchDao = (BranchDAO)Mockito.mock(BranchDAO.class);
    private final BranchIndexer branchIndexer = (BranchIndexer)Mockito.mock(BranchIndexer.class);
    private GitScannerStub scanner;
    private final GitScmConfig gitScmConfig = (GitScmConfig)Mockito.mock(GitScmConfig.class);
    private boolean forceManifestUpgrade;
    private RepositoryStatus repositoryStatusMock;
    @Rule
    public TemporaryFolder tempFolderRule = new TemporaryFolder();

    @Before
    public void setUp() throws Exception {
        this.forceManifestUpgrade = FishEyeSysProps.forceManifestUpgrade;
        FishEyeSysProps.forceManifestUpgrade = false;
        this.revisionsByHash = ArrayListMultimap.create();
        this.revisionsByHash.put((Object)GitScannerTest.createRev("a"), (Object)GitScannerTest.createRevInfo("/a/1", GitScannerTest.createDisplayRev("a")));
        this.revisionsByHash.put((Object)GitScannerTest.createRev("a"), (Object)GitScannerTest.createRevInfo("/a/2", GitScannerTest.createDisplayRev("a")));
        this.revisionsByHash.put((Object)GitScannerTest.createRev("a"), (Object)GitScannerTest.createRevInfo("/a/3", GitScannerTest.createDisplayRev("a")));
        this.revisionsByHash.put((Object)GitScannerTest.createRev("b"), (Object)GitScannerTest.createRevInfo("/b/1", GitScannerTest.createDisplayRev("b")));
        this.revisionsByHash.put((Object)GitScannerTest.createRev("b"), (Object)GitScannerTest.createRevInfo("/b/2", GitScannerTest.createDisplayRev("b")));
        this.revisionsByHash.put((Object)GitScannerTest.createRev("b"), (Object)GitScannerTest.createRevInfo("/b/3", GitScannerTest.createDisplayRev("b")));
        this.revisionsByHash.put((Object)GitScannerTest.createRev("c"), (Object)GitScannerTest.createRevInfo("/c/1", GitScannerTest.createDisplayRev("c")));
        this.revisionsByHash.put((Object)GitScannerTest.createRev("c"), (Object)GitScannerTest.createRevInfo("/c/2", GitScannerTest.createDisplayRev("c")));
        this.revisionsByHash.put((Object)GitScannerTest.createRev("d"), (Object)GitScannerTest.createRevInfo("/d/1", GitScannerTest.createDisplayRev("d")));
        this.revisionsByHash.put((Object)GitScannerTest.createRev("d"), (Object)GitScannerTest.createRevInfo("/d/2", GitScannerTest.createDisplayRev("d")));
        this.blobInfos = Lists.newArrayList();
        this.blobInfos.add("no match 1");
        this.blobInfos.add("no match 2");
        this.blobInfos.add(GitScannerTest.createBlobInfo("a", 1000L));
        this.blobInfos.add(GitScannerTest.createBlobInfo("b", 5000L));
        this.blobInfos.add(GitScannerTest.createBlobInfo("c", 10000L));
        this.blobInfos.add("no match 3");
        this.indexingConfigMock = (RepositoryConfig)Mockito.mock(RepositoryConfig.class);
        Mockito.when((Object)this.indexingConfigMock.getName()).thenReturn((Object)(this.getClass().getSimpleName() + "Repo"));
        ((RepositoryConfig)Mockito.doCallRealMethod().when((Object)this.indexingConfigMock)).isOfIndexableSize((Path)Matchers.any(Path.class), Matchers.anyLong(), Matchers.anyString());
        Mockito.when((Object)this.ctx.getScmConfig()).thenReturn((Object)this.gitScmConfig);
        Mockito.when((Object)this.engine.getLinecountCalculator()).thenReturn(Mockito.mock(BlameAndLinecountCalculator.class));
        this.scanner = this.createScannerStub(this.engine, this.ctx, this.cache, this.branchIndexer, this.branchDao);
    }

    @After
    public void tearDown() {
        FishEyeSysProps.forceManifestUpgrade = this.forceManifestUpgrade;
    }

    @Test
    public void testRemoveOversizedBlobsFromRevisionsLimit500() throws Exception {
        Mockito.when((Object)this.indexingConfigMock.getMaxIndexableSize()).thenReturn((Object)500L);
        GitScanner.removeOversizedBlobsFromRevisions(this.revisionsByHash, this.blobInfos, (IndexingConfig)this.indexingConfigMock);
        Assert.assertThat((Object)this.revisionsByHash.containsKey((Object)GitScannerTest.createRev("a")), (Matcher)org.hamcrest.Matchers.equalTo((Object)false));
        Assert.assertThat((Object)this.revisionsByHash.containsKey((Object)GitScannerTest.createRev("b")), (Matcher)org.hamcrest.Matchers.equalTo((Object)false));
        Assert.assertThat((Object)this.revisionsByHash.containsKey((Object)GitScannerTest.createRev("c")), (Matcher)org.hamcrest.Matchers.equalTo((Object)false));
        Assert.assertThat((Object)this.revisionsByHash.get((Object)GitScannerTest.createRev("d")), (Matcher)org.hamcrest.Matchers.hasSize((int)2));
    }

    @Test
    public void testRemoveOversizedBlobsFromRevisionsLimit2000() throws Exception {
        Mockito.when((Object)this.indexingConfigMock.getMaxIndexableSize()).thenReturn((Object)2000L);
        GitScanner.removeOversizedBlobsFromRevisions(this.revisionsByHash, this.blobInfos, (IndexingConfig)this.indexingConfigMock);
        Assert.assertThat((Object)this.revisionsByHash.get((Object)GitScannerTest.createRev("a")), (Matcher)org.hamcrest.Matchers.hasSize((int)3));
        Assert.assertThat((Object)this.revisionsByHash.containsKey((Object)GitScannerTest.createRev("b")), (Matcher)org.hamcrest.Matchers.equalTo((Object)false));
        Assert.assertThat((Object)this.revisionsByHash.containsKey((Object)GitScannerTest.createRev("c")), (Matcher)org.hamcrest.Matchers.equalTo((Object)false));
        Assert.assertThat((Object)this.revisionsByHash.get((Object)GitScannerTest.createRev("d")), (Matcher)org.hamcrest.Matchers.hasSize((int)2));
    }

    @Test
    public void testRemoveOversizedBlobsFromRevisionsLimit6000() throws Exception {
        Mockito.when((Object)this.indexingConfigMock.getMaxIndexableSize()).thenReturn((Object)6000L);
        GitScanner.removeOversizedBlobsFromRevisions(this.revisionsByHash, this.blobInfos, (IndexingConfig)this.indexingConfigMock);
        Assert.assertThat((Object)this.revisionsByHash.get((Object)GitScannerTest.createRev("a")), (Matcher)org.hamcrest.Matchers.hasSize((int)3));
        Assert.assertThat((Object)this.revisionsByHash.get((Object)GitScannerTest.createRev("b")), (Matcher)org.hamcrest.Matchers.hasSize((int)3));
        Assert.assertThat((Object)this.revisionsByHash.containsKey((Object)GitScannerTest.createRev("c")), (Matcher)org.hamcrest.Matchers.equalTo((Object)false));
        Assert.assertThat((Object)this.revisionsByHash.get((Object)GitScannerTest.createRev("d")), (Matcher)org.hamcrest.Matchers.hasSize((int)2));
    }

    @Test
    public void testRemoveOversizedBlobsFromRevisionsLimit11000() throws Exception {
        Mockito.when((Object)this.indexingConfigMock.getMaxIndexableSize()).thenReturn((Object)11000L);
        GitScanner.removeOversizedBlobsFromRevisions(this.revisionsByHash, this.blobInfos, (IndexingConfig)this.indexingConfigMock);
        Assert.assertThat((Object)this.revisionsByHash.get((Object)GitScannerTest.createRev("a")), (Matcher)org.hamcrest.Matchers.hasSize((int)3));
        Assert.assertThat((Object)this.revisionsByHash.get((Object)GitScannerTest.createRev("b")), (Matcher)org.hamcrest.Matchers.hasSize((int)3));
        Assert.assertThat((Object)this.revisionsByHash.get((Object)GitScannerTest.createRev("c")), (Matcher)org.hamcrest.Matchers.hasSize((int)2));
        Assert.assertThat((Object)this.revisionsByHash.get((Object)GitScannerTest.createRev("d")), (Matcher)org.hamcrest.Matchers.hasSize((int)2));
    }

    @Test
    public void testProcessesLateRemovedBranches() throws Exception {
        Branch deletedLateBranch = new Branch("DeletedLate", "123", BranchState.ACTIVE);
        Mockito.when((Object)this.ctx.getBranchesInLocalRepo()).thenReturn((Object)Sets.newHashSet());
        Mockito.when((Object)this.cache.getBranches()).thenReturn((Object)Sets.newHashSet((Object[])new Branch[]{deletedLateBranch}));
        boolean updateDetected = this.scanner.processRevisions();
        Assert.assertThat((Object)updateDetected, (Matcher)org.hamcrest.Matchers.is((Object)true));
        Branch removedBranch = new Branch(deletedLateBranch.getName(), null, BranchState.REMOVED);
        ((BranchIndexer)Mockito.verify((Object)this.branchIndexer)).indexBranches((Iterable)Matchers.eq(Collections.singleton(removedBranch)), (ChangeSetResolver)Matchers.any(ChangeSetResolver.class), (RepositoryStatus)Matchers.any(RepositoryStatus.class));
        ArgumentCaptor branchCaptor = ArgumentCaptor.forClass(Branch.class);
        ArgumentCaptor boolCaptor = ArgumentCaptor.forClass(Boolean.class);
        ((BranchDAO)Mockito.verify((Object)this.branchDao, (VerificationMode)Mockito.times((int)2))).store((Branch)branchCaptor.capture(), ((Boolean)boolCaptor.capture()).booleanValue());
        Assert.assertThat(branchCaptor.getAllValues().get(0), (Matcher)org.hamcrest.Matchers.equalTo((Object)removedBranch));
        Assert.assertThat(boolCaptor.getAllValues().get(0), (Matcher)org.hamcrest.Matchers.is((Object)true));
    }

    @Test
    public void testOnBranchHeadUpdated_shouldUpdateLastMarkedForFullyMarkedBranches() throws Exception {
        Branch inCache = this.createBranch("normalMove", "10", (Option<String>)Option.some((Object)"10"));
        Branch inScm = new Branch("normalMove", "20", BranchState.ACTIVE);
        Branch result = this.scanner.prepareBranchToBeStored(inCache, inScm);
        Assert.assertThat((Object)result, (Matcher)org.hamcrest.Matchers.equalTo((Object)inScm));
        Assert.assertThat((Object)result.getLatestMarkedChangesetId(), (Matcher)org.hamcrest.Matchers.equalTo((Object)Option.some((Object)"10")));
    }

    @Test
    public void testOnBranchHeadUpdated_shouldNotUpdateLastMarkedForIncompletelyMarkedBranches() throws Exception {
        Branch inCache = this.createBranch("notCompletelyMarked", "10", (Option<String>)Option.some((Object)"5"));
        Branch inScm = new Branch("notCompletelyMarked", "20", BranchState.ACTIVE);
        Branch result = this.scanner.prepareBranchToBeStored(inCache, inScm);
        Assert.assertThat((Object)result, (Matcher)org.hamcrest.Matchers.equalTo((Object)inScm));
        Assert.assertThat((Object)result.getLatestMarkedChangesetId(), (Matcher)org.hamcrest.Matchers.equalTo((Object)Option.some((Object)"5")));
    }

    @Test
    public void testOnBranchHeadUpdated_shouldMarkRemovedBranches() throws Exception {
        Branch inCache = this.createBranch("deletion", "10", (Option<String>)Option.some((Object)"10"));
        Branch result = this.scanner.prepareBranchToBeStored(inCache, null);
        Assert.assertThat((Object)result, (Matcher)org.hamcrest.Matchers.equalTo((Object)new Branch("deletion", null, BranchState.REMOVED)));
        Assert.assertThat((Object)result.getLatestMarkedChangesetId(), (Matcher)org.hamcrest.Matchers.equalTo((Object)Option.some((Object)"10")));
    }

    @Test
    public void testOnBranchHeadUpdated_shouldResetLastMarkedForUnmarkedBranches() throws Exception {
        Branch inCache = this.createBranch("noneMarked", "10", (Option<String>)Option.none(String.class));
        Branch inScm = new Branch("noneMarked", "20", BranchState.ACTIVE);
        Branch result = this.scanner.prepareBranchToBeStored(inCache, inScm);
        Assert.assertThat((Object)result, (Matcher)org.hamcrest.Matchers.equalTo((Object)inScm));
        Assert.assertThat((Object)result.getLatestMarkedChangesetId(), (Matcher)org.hamcrest.Matchers.equalTo((Object)Option.none(String.class)));
    }

    @Test
    public void testOnBranchHeadUpdated_shouldResetLastMarkedForNewBranches() throws Exception {
        Branch inScm = new Branch("newBranch", "20", BranchState.ACTIVE);
        Branch result = this.scanner.prepareBranchToBeStored(null, inScm);
        Assert.assertThat((Object)result, (Matcher)org.hamcrest.Matchers.equalTo((Object)inScm));
        Assert.assertThat((Object)result.getLatestMarkedChangesetId(), (Matcher)org.hamcrest.Matchers.equalTo((Object)Option.none(String.class)));
    }

    @Test
    public void testPostProcessBranches_shouldMarkAncestors() throws Exception {
        Mockito.when((Object)this.cache.getBranches()).thenReturn((Object)ImmutableSet.of((Object)this.createBranch("moved", "13", (Option<String>)Option.some((Object)"10")), (Object)this.createBranch("rebased", "12a", (Option<String>)Option.some((Object)"12")), (Object)this.createBranch("deleted", null, (Option<String>)Option.some((Object)"11"))));
        this.returnRevList("13", "10", Arrays.asList("11", "12", "13"));
        this.returnRevList("12a", "12", Arrays.asList("11a", "12a"));
        this.returnRevList("12", "12a", Arrays.asList("11", "12"));
        this.returnRevList("12", "12a", Arrays.asList("11", "12"));
        this.returnRevList("11", null, Arrays.asList("11", "10", "9"));
        boolean changed = this.scanner.postProcessBranches();
        Assert.assertTrue((boolean)changed);
        this.verifyMarkChangesetBranches("11", new String[]{"moved"}, new String[]{"rebased", "deleted"});
        this.verifyMarkChangesetBranches("12", new String[]{"moved"}, new String[]{"rebased"});
        this.verifyMarkChangesetBranches("13", new String[]{"moved"}, new String[0]);
        this.verifyMarkChangesetBranches("11a", new String[]{"rebased"}, new String[0]);
        this.verifyMarkChangesetBranches("12a", new String[]{"rebased"}, new String[0]);
        this.verifyMarkChangesetBranches("9", new String[0], new String[]{"deleted"});
        this.verifyMarkChangesetBranches("10", new String[0], new String[]{"deleted"});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.changesetDao});
        Assert.assertThat((Object)this.scanner.commitsToReindexNow, (Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new String[]{"11", "11a", "12", "12a", "13"}));
        Assert.assertThat((Object)this.scanner.commitsToReindex, (Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new String[]{"9", "10"}));
    }

    @Test
    public void testPostProcessBranches_shouldHandleManyBranches() throws Exception {
        int branchCount = 2000;
        int changesetCount = 15000;
        int expectedBatchCount = IntMath.divide((int)2000, (int)50, (RoundingMode)RoundingMode.UP);
        final AtomicInteger updateCount = new AtomicInteger();
        Iterable branches = Iterables.limit((Iterable)Iterables.transform((Iterable)Iterables.cycle((Object[])new 1[]{new Supplier<Branch>(){
            int count = 0;

            public Branch get() {
                return new Branch("branch" + this.count++, String.valueOf(15000), BranchState.ACTIVE);
            }
        }}), (Function)Suppliers.supplierFunction()), (int)2000);
        this.changesetDao = new GitChangeSetDAO(null, null, null, null, null){

            public void updateChangesetBranches(String csid, Iterable<String> addedBranches, Iterable<String> removedBranches) {
                Assert.assertThat(addedBranches, (Matcher)org.hamcrest.Matchers.iterableWithSize((int)50));
                Assert.assertThat(removedBranches, (Matcher)org.hamcrest.Matchers.emptyIterable());
                updateCount.incrementAndGet();
            }
        };
        this.ctx = new GitContext(){

            public void visitChangesetIds(String headRef, Iterable<String> excludedRefs, boolean reverse, StoppableVisitor<String> commitHashHandler) throws DvcsProcessException {
                for (Integer rev : ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(15000)), (DiscreteDomain)DiscreteDomain.integers())) {
                    commitHashHandler.visit((Object)String.valueOf(rev));
                }
            }

            public GitScmConfig getScmConfig() {
                return GitScannerTest.this.gitScmConfig;
            }
        };
        this.scanner = this.createScannerStub(this.engine, this.ctx, this.cache, this.branchIndexer, this.branchDao);
        Mockito.when((Object)this.cache.getBranches()).thenReturn((Object)ImmutableSet.copyOf((Iterable)branches));
        boolean changed = this.scanner.postProcessBranches();
        Assert.assertTrue((boolean)changed);
        ((BranchDAO)Mockito.verify((Object)this.branchDao, (VerificationMode)Mockito.times((int)2000))).store((Branch)Matchers.any(Branch.class), Matchers.eq((boolean)false));
        Assert.assertThat((Object)updateCount.get(), (Matcher)org.hamcrest.Matchers.equalTo((Object)(expectedBatchCount * 15000)));
    }

    @Test
    public void testPerformCloneCallsGitWithProperArgs() throws Exception {
        File tempDir = this.tempFolderRule.newFolder();
        File cloneLocation = this.tempFolderRule.newFolder();
        String remoteLocationAndCredentials = "someRemoteLocation";
        final GitCommandBuilder builder = new GitCommandBuilder("clone", new String[]{"--bare"});
        builder.append(new String[]{"-v", "someRemoteLocation", cloneLocation.getName()});
        this.ctx = (GitContext)Mockito.mock(GitContext.class);
        Mockito.when((Object)this.gitScmConfig.getRemoteLocationWithCredentials()).thenReturn((Object)"someRemoteLocation");
        Mockito.when((Object)this.ctx.getGitVersion()).thenReturn((Object)GitScanner.GIT_161);
        Mockito.when((Object)this.ctx.getScmConfig()).thenReturn((Object)this.gitScmConfig);
        Mockito.when((Object)this.ctx.getEncoding()).thenReturn((Object)Charset.defaultCharset());
        Mockito.when((Object)this.ctx.getRepoLocation()).thenReturn((Object)cloneLocation);
        this.scanner = this.createScannerStub(this.engine, this.ctx, this.cache, this.branchIndexer, this.branchDao);
        this.scanner.performClone(tempDir);
        ((GitContext)Mockito.verify((Object)this.ctx)).executeCommand((DvcsCommandBuilder)Matchers.argThat((Matcher)new TypeSafeMatcher<GitCommandBuilder>(){

            public void describeTo(Description description) {
                description.appendText(builder.toString());
            }

            protected boolean matchesSafely(GitCommandBuilder item) {
                List expected = builder.createCommand();
                List result = item.createCommand();
                return expected.equals(result);
            }
        }), (ProcessHandler)Matchers.any(), (File)Matchers.eq((Object)cloneLocation.getParentFile()));
        ((GitContext)Mockito.verify((Object)this.ctx)).updateLocalCloneConfig(new String[]{(String)Matchers.eq((Object)"gc.pruneExpire"), (String)Matchers.eq((Object)"never")});
    }

    @Test
    public void testRetryUnseenCommitsWithoutExclusionsOnException() throws Exception {
        this.ctx = (GitContext)Mockito.mock(GitContext.class);
        Mockito.when((Object)this.gitScmConfig.getEncoding()).thenReturn(Mockito.mock(Charset.class));
        Mockito.when((Object)this.ctx.getScmConfig()).thenReturn((Object)this.gitScmConfig);
        ((GitContext)Mockito.doThrow(DvcsProcessException.class).when((Object)this.ctx)).visitChangesetIds(Matchers.anyString(), (Iterable)Matchers.argThat((Matcher)org.hamcrest.Matchers.not((Matcher)org.hamcrest.Matchers.emptyIterable())), Matchers.eq((boolean)true), (StoppableVisitor)Matchers.any(StoppableVisitor.class));
        GitScanner scanner = this.createScanner(this.engine, this.ctx, this.cache, this.branchIndexer, this.branchDao);
        scanner.getUnseenCommits("commit-1", "commit-2", "master");
        ((GitContext)Mockito.verify((Object)this.ctx, (VerificationMode)Mockito.times((int)1))).visitChangesetIds(Matchers.anyString(), (Iterable)Matchers.argThat((Matcher)org.hamcrest.Matchers.not((Matcher)org.hamcrest.Matchers.emptyIterable())), Matchers.eq((boolean)true), (StoppableVisitor)Matchers.any(StoppableVisitor.class));
        ((GitContext)Mockito.verify((Object)this.ctx, (VerificationMode)Mockito.times((int)1))).visitChangesetIds(Matchers.anyString(), (Iterable)Matchers.argThat((Matcher)org.hamcrest.Matchers.emptyIterable()), Matchers.eq((boolean)true), (StoppableVisitor)Matchers.any(StoppableVisitor.class));
    }

    private TimeoutTestHelper configureForTagsProcessingAndReturnGitTagsToProcess() {
        Mockito.when((Object)this.cache.getMetadataVersion()).thenReturn((Object)29L);
        Mockito.when((Object)this.cache.hasScanProperty(CommonProperties.GIT_MANIFEST_UPGRADE.value)).thenReturn((Object)true);
        Mockito.when((Object)this.cache.getIndexingPhase()).thenReturn((Object)IndexingState.PROCESSING_REVISIONS);
        Mockito.when((Object)this.cache.isInitialIndexingComplete()).thenReturn((Object)true);
        TimeoutTestHelper timeoutTestHelper = new TimeoutTestHelper();
        ((GitCache)Mockito.doAnswer(invocation -> timeoutTestHelper.gitTagsToProcess.longValue() != -1L).when((Object)this.cache)).hasScanProperty((String)Matchers.eq((Object)CommonProperties.GIT_TAGS_TO_PROCESS.value));
        ((GitCache)Mockito.doAnswer(invocation -> {
            if (timeoutTestHelper.gitTagsToProcess.longValue() != -1L) {
                return timeoutTestHelper.gitTagsToProcess.longValue();
            }
            return invocation.getArguments()[1];
        }).when((Object)this.cache)).getScanProperty((String)Matchers.eq((Object)CommonProperties.GIT_TAGS_TO_PROCESS.value), Matchers.anyLong());
        ((GitCache)Mockito.doAnswer(invocation -> {
            timeoutTestHelper.gitTagsToProcess.set((Long)invocation.getArguments()[1]);
            return null;
        }).when((Object)this.cache)).setScanProperty((String)Matchers.eq((Object)CommonProperties.GIT_TAGS_TO_PROCESS.value), Matchers.anyLong());
        return timeoutTestHelper;
    }

    @Test
    public void testProcessingTagsWithTimeoutFirstRun() throws Exception {
        TimeoutTestHelper timeoutTestHelper = this.configureForTagsProcessingAndReturnGitTagsToProcess();
        timeoutTestHelper.gitTagsToProcess.set(-1L);
        this.scanner.slurpRepository(false);
        Assert.assertThat((Object)timeoutTestHelper.gitTagsToProcess.get(), (Matcher)org.hamcrest.Matchers.equalTo((Object)0L));
    }

    @Test
    public void testProcessingTagsWithTimeoutNoTagsToProcess() throws Exception {
        TimeoutTestHelper timeoutTestHelper = this.configureForTagsProcessingAndReturnGitTagsToProcess();
        timeoutTestHelper.gitTagsToProcess.set(0L);
        this.scanner.slurpRepository(false);
        ((RepositoryStatus)Mockito.verify((Object)this.repositoryStatusMock, (VerificationMode)Mockito.times((int)0))).setMessage((String)Matchers.eq((Object)"Processing tags"));
        Assert.assertThat((Object)timeoutTestHelper.gitTagsToProcess.get(), (Matcher)org.hamcrest.Matchers.equalTo((Object)0L));
    }

    @Test
    public void testProcessingTagsWithTimeoutTagsToProcess() throws Exception {
        TimeoutTestHelper timeoutTestHelper = this.configureForTagsProcessingAndReturnGitTagsToProcess();
        timeoutTestHelper.gitTagsToProcess.set(1L);
        this.scanner.slurpRepository(false);
        ((RepositoryStatus)Mockito.verify((Object)this.repositoryStatusMock, (VerificationMode)Mockito.times((int)1))).setMessage((String)Matchers.eq((Object)"Processing tags"));
        Assert.assertThat((Object)timeoutTestHelper.gitTagsToProcess.get(), (Matcher)org.hamcrest.Matchers.equalTo((Object)0L));
    }

    @Test
    public void testDoNotFetchDiffIfNoneOfThePathsAreInWatchedArea() throws Exception {
        GitScanner scanner = (GitScanner)Mockito.spy((Object)this.createScanner(this.engine, this.ctx, this.cache, this.branchIndexer, this.branchDao));
        GitCommitDetails commitDetails = new GitCommitDetails("some-branch", "somehash");
        String filePathOutsideWatchedArea = "/some/extra/file";
        commitDetails.addPath(new GitChangePath("/some/extra/file"));
        Mockito.when((Object)this.ctx.isPathInRepo((String)Matchers.eq((Object)"/some/extra/file"))).thenReturn((Object)false);
        scanner.populateDiffInfo(commitDetails);
        ((GitContext)Mockito.verify((Object)this.ctx, (VerificationMode)Mockito.never())).executeCommand((DvcsCommandBuilder)Matchers.any(DvcsCommandBuilder.class), (OutputHandler)Matchers.any(OutputHandler.class));
    }

    @Test
    public void testFetchDiffIfAtLeastOneOfThePathIsInWatchedArea() throws Exception {
        GitScanner scanner = this.createScanner(this.engine, this.ctx, this.cache, this.branchIndexer, this.branchDao);
        GitCommitDetails commitDetails = new GitCommitDetails("some-branch", "somehash");
        String filePathOutsideWatchedArea = "/some/extra/file";
        String filePathInWatchedArea = "/file/in/watched/area";
        commitDetails.addPath(new GitChangePath("/some/extra/file"));
        commitDetails.addPath(new GitChangePath("/file/in/watched/area"));
        Mockito.when((Object)this.ctx.isPathInRepo((String)Matchers.eq((Object)"/some/extra/file"))).thenReturn((Object)false);
        Mockito.when((Object)this.ctx.isPathInRepo((String)Matchers.eq((Object)"/file/in/watched/area"))).thenReturn((Object)true);
        scanner.populateDiffInfo(commitDetails);
        ArgumentMatcher<DvcsCommandBuilder> commandMatcher = new ArgumentMatcher<DvcsCommandBuilder>(){

            public boolean matches(Object argument) {
                DvcsCommandBuilder commandBuilder = (DvcsCommandBuilder)argument;
                String command = Joiner.on((String)" ").join((Iterable)commandBuilder.createCommand());
                return org.hamcrest.Matchers.anyOf((Matcher)org.hamcrest.Matchers.startsWith((String)"diff"), (Matcher)org.hamcrest.Matchers.startsWith((String)"whatchanged")).matches((Object)command);
            }

            public void describeTo(Description description) {
                description.appendText("<git diff or git whatchanged command>");
            }
        };
        ((GitContext)Mockito.verify((Object)this.ctx, (VerificationMode)Mockito.times((int)1))).executeCommand((DvcsCommandBuilder)Matchers.argThat((Matcher)commandMatcher), (OutputHandler)Matchers.any(OutputHandler.class));
    }

    private void verifyMarkChangesetBranches(String csid, String[] addedBranches, String[] removedBranches) {
        ((GitChangeSetDAO)Mockito.verify((Object)this.changesetDao)).updateChangesetBranches((String)Matchers.eq((Object)csid), (Iterable)Matchers.argThat((Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])addedBranches)), (Iterable)Matchers.argThat((Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])removedBranches)));
    }

    private void returnRevList(String head, String tail, List<String> revs) throws DvcsProcessException {
        ((GitContext)Mockito.doAnswer(invocation -> {
            StoppableVisitor predicate = (StoppableVisitor)invocation.getArguments()[3];
            for (String rev : revs) {
                predicate.visit((Object)rev);
            }
            return null;
        }).when((Object)this.ctx)).visitChangesetIds((String)Matchers.eq((Object)head), (Iterable)Matchers.eq((Object)Option.option((Object)tail)), Matchers.eq((boolean)false), (StoppableVisitor)Matchers.any(StoppableVisitor.class));
    }

    private Branch createBranch(String name, String lastCsid, Option<String> lastMarked) {
        Branch branch = new Branch(name, lastCsid, BranchState.ACTIVE);
        branch.setLatestMarkedChangesetId(lastMarked);
        return branch;
    }

    private GitScannerStub createScannerStub(GitRepositoryEngine engine, GitContext ctx, GitCache cache, BranchIndexer branchIndexer, BranchDAO branchDao) throws ConfigException {
        this.mockGitScannerDependencies(engine, ctx, cache, branchIndexer, branchDao);
        GitScannerStub scanner = new GitScannerStub(engine);
        this.mockInfDbHandle(cache, scanner);
        return scanner;
    }

    private void mockInfDbHandle(GitCache cache, GitScanner scanner) throws ConfigException {
        InfinityDbHandle mockDb = (InfinityDbHandle)Mockito.mock(InfinityDbHandle.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)cache.getInfDb()).thenReturn((Object)mockDb);
        Mockito.when((Object)cache.getChangeSetDAO()).thenReturn((Object)this.changesetDao);
        scanner.start(cache);
        scanner.commitsToReindex = Sets.newHashSet();
        scanner.commitsToReindexNow = Sets.newHashSet();
    }

    private void mockGitScannerDependencies(GitRepositoryEngine engine, GitContext ctx, GitCache cache, BranchIndexer branchIndexer, BranchDAO branchDao) {
        RepositoryConfig config = (RepositoryConfig)Mockito.mock(RepositoryConfig.class);
        IndexingContext indexingContext = (IndexingContext)Mockito.mock(IndexingContext.class);
        Mockito.when((Object)engine.getIndexingContext()).thenReturn((Object)indexingContext);
        Mockito.when((Object)engine.getCfg()).thenReturn((Object)config);
        Mockito.when((Object)engine.getContext()).thenReturn((Object)ctx);
        this.repositoryStatusMock = (RepositoryStatus)Mockito.mock(RepositoryStatus.class);
        Mockito.when((Object)config.getStatus()).thenReturn((Object)this.repositoryStatusMock);
        Mockito.when((Object)indexingContext.getBranchCrossRepoIndexer()).thenReturn((Object)branchIndexer);
        Mockito.when((Object)cache.getBranchDAO()).thenReturn((Object)branchDao);
        Mockito.when((Object)this.gitScmConfig.getRenameMode()).thenReturn((Object)RenameOptions.COPIES);
    }

    private GitScanner createScanner(GitRepositoryEngine engine, GitContext ctx, GitCache cache, BranchIndexer branchIndexer, BranchDAO branchDao) throws ConfigException {
        this.mockGitScannerDependencies(engine, ctx, cache, branchIndexer, branchDao);
        GitScanner scanner = new GitScanner(engine);
        this.mockInfDbHandle(cache, scanner);
        return scanner;
    }

    private static String createBlobInfo(String c, long size) {
        return GitScannerTest.createRev(c) + " blob " + size;
    }

    private static String createRev(String c) {
        return Strings.repeat((String)c, (int)40);
    }

    private static String createDisplayRev(String c) {
        return Strings.repeat((String)c, (int)7);
    }

    private static DvcsRevInfo createRevInfo(final String path, final String displayRevision) {
        return new DvcsRevInfo(){

            public Path getPath() {
                return new Path((CharSequence)path);
            }

            public String getDisplayRevision() {
                return displayRevision;
            }

            public String getEmail() {
                return "author@gmail.com";
            }
        };
    }

    private static class GitScannerStub
    extends GitScanner {
        public GitScannerStub(GitRepositoryEngine engine) {
            super(engine);
        }

        protected Set<String> getUpdatedCommits() {
            return Sets.newHashSet();
        }

        protected Set<String> getCommitsProcessed() {
            return Sets.newHashSet();
        }

        protected void resetCommitsProcessed() {
        }
    }

    private static class TimeoutTestHelper {
        AtomicLong gitTagsToProcess = new AtomicLong(-1L);

        private TimeoutTestHelper() {
        }
    }
}

