/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git;

import com.atlassian.fisheye.dvcs.DvcsRepoValidation;
import com.atlassian.fisheye.git.GitCache;
import com.atlassian.fisheye.git.GitTestBase;
import com.atlassian.fisheye.git.db.GitChangeSetDAO;
import com.cenqua.fisheye.config1.RenameOptions;
import com.cenqua.fisheye.lucene.BranchIndexingChecker;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.DbException;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.junit.Test;

public class GitSanityTest
extends GitTestBase {
    private static final String BINARY_D_ZIP = "binary/D.zip";
    private static final String BINARY_C_ZIP = "binary/C.zip";
    private static final String BINARY_B_ZIP = "binary/B.zip";
    private static final String BINARY_A_ZIP = "binary/A.zip";
    private static final int TEST_BLOCK_SIZE = 1;
    private static final String[] MASTER_BASIC_MODMERGE_OUTOFORDER = new String[]{"master", "basic_branching", "branch_mod_merge", "out_of_order_branch"};
    private static final String[] MASTER_BASIC_MODMERGE = new String[]{"master", "basic_branching", "branch_mod_merge"};
    private static final String[] BASIC = new String[]{"basic_branching"};
    private static final String[] MASTER_MODMERGE = new String[]{"master", "branch_mod_merge"};
    private static final String MICHAEL_HEEMSKERK = "Michael Heemskerk <mheemskerk@atlassian.com>";
    private static final String ANNA_BUTTFIELD = "Anna Buttfield <abuttfield@cascade.sydney.atlassian.com>";

    public GitSanityTest() {
        super("git-sanity");
    }

    @Override
    protected int getBlockSize() {
        return 1;
    }

    @Override
    protected RenameOptions.Enum getRenameDetection() {
        return RenameOptions.DETAILED;
    }

    @Test
    public void testSanity() throws Exception {
        this.verifyBranchIndexing();
        this.verifyCommitGraph();
        this.verifyAddFile();
        this.verifyBasicBranching();
        this.verifyBranchModMerge();
        this.verifyDeleteFile();
        this.verifyModification();
        this.verifyMoveDirectory();
        this.verifyOutOfOrderCommits();
        this.verifySymlink();
        this.verifyBinaryFiles();
        this.verifyBranchHeads();
        this.verifyChangesetsOnBranches();
    }

    private void verifyBranchIndexing() {
        BranchIndexingChecker.verifyIndexedBranchesWithRevCache(this.getCache());
    }

    private void verifyChangesetsOnBranches() throws DbException {
        this.assertNumBranchChangesets("master", 21);
        this.assertNumBranchChangesets("basic_branching", 15);
        this.assertNumBranchChangesets("branch_mod_merge", 16);
        this.assertNumBranchChangesets("out_of_order_branch", 3);
    }

    private void assertNumBranchChangesets(String branchName, int numChangesets) throws DbException {
        GitChangeSetDAO csDAO = ((GitCache)this.getCache()).getChangeSetDAO();
        ListIterator iterator = csDAO.getChangeSetsOnBranch(branchName, null).iterator();
        int count = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        Assert.assertEquals((String)("Incorrect number of changesets on " + branchName), (int)numChangesets, (int)count);
    }

    private void verifyBranchHeads() throws DbException {
        Map<String, Branch> branchMap = this.getBranchMap();
        this.assertBranchHead(branchMap, "master", "b85cc38f352507931b0f9ff76fbcfc549629df72");
        this.assertBranchHead(branchMap, "basic_branching", "d6edcbf924697ab811a867421dab60d954ccad99");
        this.assertBranchHead(branchMap, "branch_mod_merge", "6053a1eaa1c009dd11092d09a72f3c41af1b59ad");
        this.assertBranchHead(branchMap, "out_of_order_branch", "2e10dd2d1d5eea9291b296e78312e8a703964a95");
    }

    private void assertBranchHead(Map<String, Branch> branchMap, String branchName, String headCommit) {
        Branch branch = branchMap.get(branchName);
        Assert.assertNotNull((String)("Could not find Branch for " + branchName), (Object)branch);
        Assert.assertEquals((String)("Branch head mismatch for " + branchName), (String)headCommit, (String)branch.getLatestChangeSetId());
    }

    public Map<String, Branch> getBranchMap() throws DbException {
        HashMap<String, Branch> branchMap = new HashMap<String, Branch>();
        for (Branch branch : ((GitCache)this.getCache()).getBranches()) {
            branchMap.put(branch.getName(), branch);
        }
        return branchMap;
    }

    private void verifyCommitGraph() throws Exception {
        this.assertCommitData(DvcsRepoValidation.Commits.first("409a2180fd95b744df8d817e770b7f8c853f78dc", MICHAEL_HEEMSKERK, "out of order commits scenario, initial commit\n", MASTER_BASIC_MODMERGE_OUTOFORDER, 1263078610000L, 1).next("c2608f5dff150e2b26b4b68d9e22369581b39b0c", "409a2180fd95b744df8d817e770b7f8c853f78dc", MICHAEL_HEEMSKERK, "modification, with earlier date than its parent\n", MASTER_BASIC_MODMERGE_OUTOFORDER, 1263074949000L, 1).next("2e10dd2d1d5eea9291b296e78312e8a703964a95", "c2608f5dff150e2b26b4b68d9e22369581b39b0c", MICHAEL_HEEMSKERK, "mod on branch, earlier than its parent\n", MASTER_BASIC_MODMERGE_OUTOFORDER, 1263071288000L, 1).next("e26cab95a50f6e99d2c46c498a23cee307cc8e27", "2e10dd2d1d5eea9291b296e78312e8a703964a95", MICHAEL_HEEMSKERK, "plain modification, initial add\n", MASTER_BASIC_MODMERGE, 1292816091000L, 1).next("bf3346620ec9161977fc23dee1240a7991e64ca1", "e26cab95a50f6e99d2c46c498a23cee307cc8e27", MICHAEL_HEEMSKERK, "edited modification/mod_file.txt\n", MASTER_BASIC_MODMERGE, 1292816091000L, 1).next("8a71bdc3c67e49729db5f17f0477cee857fd7ae7", "bf3346620ec9161977fc23dee1240a7991e64ca1", MICHAEL_HEEMSKERK, "add a file\n", MASTER_BASIC_MODMERGE, 1292816101000L, 1).next("4f9290ae1a9fcde7acd56664a22cc65eb76540f3", "8a71bdc3c67e49729db5f17f0477cee857fd7ae7", MICHAEL_HEEMSKERK, "delete file scenario\n", MASTER_BASIC_MODMERGE, 1292816132000L, 1).next("6d8e9736357657738d15cd29069f21bf44553e19", "4f9290ae1a9fcde7acd56664a22cc65eb76540f3", MICHAEL_HEEMSKERK, "deleted file del_file/del_file.txt\n", MASTER_BASIC_MODMERGE, 1292816132000L, 1).next("9fbc34a0d905950131d73f352abe68520c6db2a3", "6d8e9736357657738d15cd29069f21bf44553e19", MICHAEL_HEEMSKERK, "move file scenario\n", MASTER_BASIC_MODMERGE, 1292816238000L, 1).next("57150c54c38d6570b2fd5e6d6cfc19476de44e84", "9fbc34a0d905950131d73f352abe68520c6db2a3", MICHAEL_HEEMSKERK, "moved mv_file.txt to moved_file.txt\n", MASTER_BASIC_MODMERGE, 1292816238000L, 2).next("05c78271ed4d7a158fe6789f6b27e3a47631faba", "57150c54c38d6570b2fd5e6d6cfc19476de44e84", MICHAEL_HEEMSKERK, "symlink scenario\n", MASTER_BASIC_MODMERGE, 1292816337000L, 2).next("ed69be6064dcef2d0b08b35192f581613e48411b", "05c78271ed4d7a158fe6789f6b27e3a47631faba", MICHAEL_HEEMSKERK, "about to move a directory\n", MASTER_BASIC_MODMERGE, 1292816350000L, 1).next("53979b3304bece75a3852a3d250dbaed64d45430", "ed69be6064dcef2d0b08b35192f581613e48411b", MICHAEL_HEEMSKERK, "moved mv_dir to moved_dir\n", MASTER_BASIC_MODMERGE, 1292816350000L, 2).next("8fb8538799b2481750eac52716931d895d029b7c", "53979b3304bece75a3852a3d250dbaed64d45430", MICHAEL_HEEMSKERK, "basic branching scenario\n", MASTER_BASIC_MODMERGE, 1292816368000L, 1).next("d6edcbf924697ab811a867421dab60d954ccad99", "8fb8538799b2481750eac52716931d895d029b7c", MICHAEL_HEEMSKERK, "a modification on branch basic_branching\n", BASIC, 1292816368000L, 1).next("042fb0cc198e7320b59a025689b45a2cb52f4684", "8fb8538799b2481750eac52716931d895d029b7c", MICHAEL_HEEMSKERK, "branch, mod and merge scenario\n", MASTER_MODMERGE, 1292816475000L, 1).next("6053a1eaa1c009dd11092d09a72f3c41af1b59ad", "042fb0cc198e7320b59a025689b45a2cb52f4684", MICHAEL_HEEMSKERK, "modification on branch_mod_merge\n", MASTER_MODMERGE, 1292816475000L, 1).next("9c05f43f859375e392d90d23a13717c16d0fdcda", "6053a1eaa1c009dd11092d09a72f3c41af1b59ad", ANNA_BUTTFIELD, "Add binary file A.zip\n", "master", 1296709147000L, 1).next("2d8897c9ac29ce42c3442cf80ac977057045e7f6", "9c05f43f859375e392d90d23a13717c16d0fdcda", ANNA_BUTTFIELD, "Rename A.zip to B.zip\n", "master", 1296709182000L, 2).next("e0a3f6d8c804c375f49d7609328111e8dc75a4bc", "2d8897c9ac29ce42c3442cf80ac977057045e7f6", ANNA_BUTTFIELD, "Add binary file C.zip\n", "master", 1296709220000L, 1).next("0a943a29376f2336b78312d99e65da17048951db", "e0a3f6d8c804c375f49d7609328111e8dc75a4bc", ANNA_BUTTFIELD, "Copy C.zip as D.zip\n", "master", 1296709267000L, 1).next("b85cc38f352507931b0f9ff76fbcfc549629df72", "0a943a29376f2336b78312d99e65da17048951db", ANNA_BUTTFIELD, "Modified D.zip\n", "master", 1297049905000L, 1).l());
    }

    private void verifyAddFile() throws Exception {
        this.assertRevisionData(DvcsRepoValidation.FileRevs.file("add_file/add_file.txt").rev("8a71bdc3c67e49729db5f17f0477cee857fd7ae7", null, null, MICHAEL_HEEMSKERK, "add a file\n", 1292816101000L, MASTER_BASIC_MODMERGE, DvcsRepoValidation.RevState.Added, "add_file/add_file.txt", false, 1, 1, 0));
    }

    private void verifyBasicBranching() throws Exception {
        this.assertRevisionData(DvcsRepoValidation.FileRevs.file("basic_branching/file.txt").rev("8fb8538799b2481750eac52716931d895d029b7c", null, null, MICHAEL_HEEMSKERK, "basic branching scenario\n", 1292816368000L, MASTER_BASIC_MODMERGE, DvcsRepoValidation.RevState.Added, "basic_branching/file.txt", false, 1, 1, 0).rev("d6edcbf924697ab811a867421dab60d954ccad99", "8fb8538799b2481750eac52716931d895d029b7c", null, MICHAEL_HEEMSKERK, "a modification on branch basic_branching\n", 1292816368000L, BASIC, DvcsRepoValidation.RevState.Modified, "basic_branching/file.txt", false, 1, 1, 1));
    }

    private void verifyBranchModMerge() throws Exception {
        this.assertRevisionData(DvcsRepoValidation.FileRevs.file("branch_mod_merge/file.txt").rev("042fb0cc198e7320b59a025689b45a2cb52f4684", null, null, MICHAEL_HEEMSKERK, "branch, mod and merge scenario\n", 1292816475000L, MASTER_MODMERGE, DvcsRepoValidation.RevState.Added, "branch_mod_merge/file.txt", false, 1, 1, 0).rev("6053a1eaa1c009dd11092d09a72f3c41af1b59ad", "042fb0cc198e7320b59a025689b45a2cb52f4684", null, MICHAEL_HEEMSKERK, "modification on branch_mod_merge\n", 1292816475000L, MASTER_MODMERGE, DvcsRepoValidation.RevState.Modified, "basic_branching/file.txt", false, 2, 1, 0));
    }

    private void verifyDeleteFile() throws Exception {
        this.assertRevisionData(DvcsRepoValidation.FileRevs.file("del_file/del_file.txt").rev("4f9290ae1a9fcde7acd56664a22cc65eb76540f3", null, null, MICHAEL_HEEMSKERK, "delete file scenario\n", 1292816132000L, MASTER_BASIC_MODMERGE, DvcsRepoValidation.RevState.Added, "del_file/del_file.txt", false, 1, 1, 0).rev("6d8e9736357657738d15cd29069f21bf44553e19", "4f9290ae1a9fcde7acd56664a22cc65eb76540f3", null, MICHAEL_HEEMSKERK, "deleted file del_file/del_file.txt\n", 1292816132000L, MASTER_BASIC_MODMERGE, DvcsRepoValidation.RevState.Deleted, "del_file/del_file.txt", false, 0, 0, 1));
    }

    private void verifyModification() throws Exception {
        this.assertRevisionData(DvcsRepoValidation.FileRevs.file("modification/mod_file.txt").rev("e26cab95a50f6e99d2c46c498a23cee307cc8e27", null, null, MICHAEL_HEEMSKERK, "plain modification, initial add\n", 1292816091000L, MASTER_BASIC_MODMERGE, DvcsRepoValidation.RevState.Added, "modification/mod_file.txt", false, 1, 1, 0).rev("bf3346620ec9161977fc23dee1240a7991e64ca1", "e26cab95a50f6e99d2c46c498a23cee307cc8e27", null, MICHAEL_HEEMSKERK, "edited modification/mod_file.txt\n", 1292816091000L, MASTER_BASIC_MODMERGE, DvcsRepoValidation.RevState.Modified, "modification/mod_file.txt", false, 2, 1, 0));
    }

    private void verifyMoveDirectory() throws Exception {
        this.assertRevisionData(DvcsRepoValidation.FileRevs.file("mv_dir/file.txt").rev("ed69be6064dcef2d0b08b35192f581613e48411b", null, null, MICHAEL_HEEMSKERK, "about to move a directory\n", 1292816350000L, MASTER_BASIC_MODMERGE, DvcsRepoValidation.RevState.Added, "mv_dir/file.txt", false, 1, 1, 0).rev("53979b3304bece75a3852a3d250dbaed64d45430", "ed69be6064dcef2d0b08b35192f581613e48411b", null, MICHAEL_HEEMSKERK, "moved mv_dir to moved_dir\n", 1292816350000L, MASTER_BASIC_MODMERGE, DvcsRepoValidation.RevState.Deleted, "mv_dir/file.txt", false, 0, 0, 1));
        this.assertRevisionData(DvcsRepoValidation.FileRevs.file("moved_dir/file.txt").rev("53979b3304bece75a3852a3d250dbaed64d45430", "ed69be6064dcef2d0b08b35192f581613e48411b", null, MICHAEL_HEEMSKERK, "moved mv_dir to moved_dir\n", 1292816350000L, MASTER_BASIC_MODMERGE, DvcsRepoValidation.RevState.Renamed, "mv_dir/file.txt", false, 1, 0, 0));
    }

    private void verifyOutOfOrderCommits() throws Exception {
        this.assertRevisionData(DvcsRepoValidation.FileRevs.file("out_of_order/file.txt").rev("409a2180fd95b744df8d817e770b7f8c853f78dc", null, null, MICHAEL_HEEMSKERK, "out of order commits scenario, initial commit\n", 1263078610000L, MASTER_BASIC_MODMERGE_OUTOFORDER, DvcsRepoValidation.RevState.Added, "out_of_order/file.txt", false, 1, 1, 0).rev("c2608f5dff150e2b26b4b68d9e22369581b39b0c", "409a2180fd95b744df8d817e770b7f8c853f78dc", null, MICHAEL_HEEMSKERK, "modification, with earlier date than its parent\n", 1263074949000L, MASTER_BASIC_MODMERGE_OUTOFORDER, DvcsRepoValidation.RevState.Modified, "out_of_order/file.txt", false, 2, 1, 0).rev("2e10dd2d1d5eea9291b296e78312e8a703964a95", "c2608f5dff150e2b26b4b68d9e22369581b39b0c", null, MICHAEL_HEEMSKERK, "mod on branch, earlier than its parent\n", 1263071288000L, MASTER_BASIC_MODMERGE_OUTOFORDER, DvcsRepoValidation.RevState.Modified, "out_of_order/file.txt", false, 3, 1, 0));
    }

    private void verifySymlink() throws Exception {
        this.assertRevisionData(DvcsRepoValidation.FileRevs.file("symlink/target.txt").rev("05c78271ed4d7a158fe6789f6b27e3a47631faba", null, null, MICHAEL_HEEMSKERK, "symlink scenario\n", 1292816337000L, MASTER_BASIC_MODMERGE, DvcsRepoValidation.RevState.Added, "symlink/target.txt", false, 1, 1, 0));
        this.assertRevisionData(DvcsRepoValidation.FileRevs.file("symlink/link.txt").rev("05c78271ed4d7a158fe6789f6b27e3a47631faba", null, null, MICHAEL_HEEMSKERK, "symlink scenario\n", 1292816337000L, MASTER_BASIC_MODMERGE, DvcsRepoValidation.RevState.Added, "symlink/link.txt", false, 1, 1, 0));
    }

    private void verifyBinaryFiles() throws DbException {
        TestCase.assertEquals((Object)this.getRenameDetection(), (Object)RenameOptions.DETAILED);
        this.assertRevisionData(DvcsRepoValidation.FileRevs.file(BINARY_A_ZIP).rev("9c05f43f859375e392d90d23a13717c16d0fdcda").author(ANNA_BUTTFIELD).msg("Add binary file A.zip\n").date(1296709147000L).state(DvcsRepoValidation.RevState.Added).branch("master").binary(true).rev("2d8897c9ac29ce42c3442cf80ac977057045e7f6").author(ANNA_BUTTFIELD).msg("Rename A.zip to B.zip\n").date(1296709182000L).state(DvcsRepoValidation.RevState.Deleted).fromPath(BINARY_A_ZIP).branch("master").binary(true).parent(BINARY_A_ZIP, "9c05f43f859375e392d90d23a13717c16d0fdcda"));
        this.assertRevisionData(DvcsRepoValidation.FileRevs.file(BINARY_B_ZIP).rev("2d8897c9ac29ce42c3442cf80ac977057045e7f6").author(ANNA_BUTTFIELD).msg("Rename A.zip to B.zip\n").date(1296709182000L).state(DvcsRepoValidation.RevState.Renamed).fromPath(BINARY_A_ZIP).branch("master").binary(true).parent(BINARY_A_ZIP, "9c05f43f859375e392d90d23a13717c16d0fdcda"));
        this.assertRevisionData(DvcsRepoValidation.FileRevs.file(BINARY_C_ZIP).rev("e0a3f6d8c804c375f49d7609328111e8dc75a4bc").author(ANNA_BUTTFIELD).msg("Add binary file C.zip\n").date(1296709220000L).state(DvcsRepoValidation.RevState.Added).branch("master").binary(true));
        this.assertRevisionData(DvcsRepoValidation.FileRevs.file(BINARY_D_ZIP).rev("0a943a29376f2336b78312d99e65da17048951db").author(ANNA_BUTTFIELD).msg("Copy C.zip as D.zip\n").date(1296709267000L).state(DvcsRepoValidation.RevState.Copied).fromPath(BINARY_C_ZIP).branch("master").binary(true).parent(BINARY_C_ZIP, "e0a3f6d8c804c375f49d7609328111e8dc75a4bc").rev("b85cc38f352507931b0f9ff76fbcfc549629df72").author(ANNA_BUTTFIELD).msg("Modified D.zip\n").date(1297049905000L).state(DvcsRepoValidation.RevState.Modified).branch("master").binary(true).parent(BINARY_D_ZIP, "0a943a29376f2336b78312d99e65da17048951db"));
    }
}

