/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git;

import com.atlassian.fisheye.git.GitCache;
import com.atlassian.fisheye.git.GitTestBase;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.FileRevision;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class GitRevisionResolutionTest
extends GitTestBase {
    @Test
    public void testHeadFindFileRevision() throws Exception {
        this.slurpDump("gitcachetest");
        FileRevision fileRevisionHead = ((GitCache)this.getCache()).findFileRevision(new Path((CharSequence)"src/Test1.java"), "HEAD");
        Assert.assertNotNull((Object)fileRevisionHead);
        FileRevision fileRevisionMaster = ((GitCache)this.getCache()).findFileRevision(new Path((CharSequence)"src/Test1.java"), "master");
        Assert.assertThat((Object)fileRevisionMaster.getRevision(), (Matcher)CoreMatchers.equalTo((Object)fileRevisionHead.getRevision()));
    }

    @Test
    public void testFindFileRevisionByRevisionFull() throws Exception {
        this.slurpDump("gitcachetest");
        Assert.assertThat((Object)"53aa325d92bd6b386340a90c0d7c42454d299949", (Matcher)CoreMatchers.equalTo((Object)((GitCache)this.getCache()).findFileRevision(new Path((CharSequence)"src/Test1.java"), "53aa325d92bd6b386340a90c0d7c42454d299949").getRevision()));
        Assert.assertThat((Object)"c099237214ea09310120163ce53bba5e5e3dc77a", (Matcher)CoreMatchers.equalTo((Object)((GitCache)this.getCache()).findFileRevision(new Path((CharSequence)"src/Test1.java"), "c099237214ea09310120163ce53bba5e5e3dc77a").getRevision()));
        Assert.assertThat((Object)"65535e7ee4e6200b0b2b7d5d9e9a970d7f75e57e", (Matcher)CoreMatchers.equalTo((Object)((GitCache)this.getCache()).findFileRevision(new Path((CharSequence)"src/Test1.java"), "65535e7ee4e6200b0b2b7d5d9e9a970d7f75e57e").getRevision()));
    }

    @Test
    public void testFindFileRevisionByRevisionPartial() throws Exception {
        this.slurpDump("gitcachetest");
        Assert.assertThat((Object)"53aa325d92bd6b386340a90c0d7c42454d299949", (Matcher)CoreMatchers.equalTo((Object)((GitCache)this.getCache()).findFileRevision(new Path((CharSequence)"src/Test1.java"), "53aa").getRevision()));
        Assert.assertThat((Object)"c099237214ea09310120163ce53bba5e5e3dc77a", (Matcher)CoreMatchers.equalTo((Object)((GitCache)this.getCache()).findFileRevision(new Path((CharSequence)"src/Test1.java"), "c099").getRevision()));
        Assert.assertThat((Object)"65535e7ee4e6200b0b2b7d5d9e9a970d7f75e57e", (Matcher)CoreMatchers.equalTo((Object)((GitCache)this.getCache()).findFileRevision(new Path((CharSequence)"src/Test1.java"), "65535").getRevision()));
    }

    @Test
    public void testFindFileRevisionByBranch() throws Exception {
        this.slurpDump("moveonbranch");
        Assert.assertNotNull((Object)((GitCache)this.getCache()).findFileRevision(new Path((CharSequence)"d1/filea.txt"), "br1").getRevision());
    }
}

