/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git;

import com.atlassian.fisheye.event.DvcsCommitEventImpl;
import com.atlassian.fisheye.event.RepositoryScanProcessedEvent;
import com.atlassian.fisheye.git.GitTestBase;
import com.atlassian.fisheye.git.GitTestHarness;
import com.atlassian.fisheye.rep.RepositoryEventCollector;
import com.cenqua.fisheye.rep.BranchChange;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class GitRepositoryScanProcessedEventTest
extends GitTestBase {
    private RepositoryEventCollector eventCollector = new RepositoryEventCollector();

    public GitRepositoryScanProcessedEventTest() {
        super("scanprocessed-step1");
    }

    @Override
    protected GitTestHarness createHarness() {
        return new GitTestHarness(){

            @Override
            protected void beforeEngineStarted() {
                super.beforeEngineStarted();
                this.registerCommitEventGenerator();
                this.getEventPublisher().register((Object)GitRepositoryScanProcessedEventTest.this.eventCollector);
            }
        };
    }

    @Test
    public void testScanProcessedEvent() throws Exception {
        List<Object> eventsAfterInitial = this.eventCollector.getAndClearEvents();
        this.slurpIncremental("scanprocessed-step2");
        List<Object> eventsAfterIncremental = this.eventCollector.getAndClearEvents();
        this.slurpIncremental("scanprocessed-step2");
        List<Object> eventsAfterSubsequent = this.eventCollector.getAndClearEvents();
        Assert.assertThat(eventsAfterInitial, (Matcher)Matchers.empty());
        Assert.assertThat(eventsAfterIncremental, (Matcher)Matchers.contains((Object[])new Object[]{new DvcsCommitEventImpl(((GitTestHarness)this.testHarness).getRepoName(), "be3b67f1a88c8d877038f3e25b92a201f4046481", false), new RepositoryScanProcessedEvent(((GitTestHarness)this.testHarness).getRepoName(), Collections.singleton("be3b67f1a88c8d877038f3e25b92a201f4046481"), (Iterable)ImmutableSet.of((Object)new BranchChange("branch1", BranchChange.ChangeType.REMOVED), (Object)new BranchChange("branch2", BranchChange.ChangeType.MODIFIED), (Object)new BranchChange("branch3", BranchChange.ChangeType.ADDED)))}));
        Assert.assertThat(eventsAfterSubsequent, (Matcher)Matchers.empty());
    }
}

