/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git;

import com.atlassian.fisheye.dvcs.DvcsRepoValidation;
import com.atlassian.fisheye.git.GitCache;
import com.atlassian.fisheye.git.GitTestBase;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.RevInfoKey;
import java.util.List;

public abstract class GitRenameDetectionTestBase
extends GitTestBase {
    private static final String ANNA_BUTTFIELD = "Anna Buttfield <abuttfield@cascade.sydney.atlassian.com>";

    public GitRenameDetectionTestBase() {
        super("copy-move");
    }

    protected void verifyCommitsWithRenameDetectionOn() throws Exception {
        this.assertCommitData(DvcsRepoValidation.Commits.first("554f718166e67dde806ff5561c27d5b9c8f4b17b", ANNA_BUTTFIELD, "initial commit\n", "master", 1290658905000L, 2).next("25570b2d856c97716e119c4584bb7b2e65853bcf", "554f718166e67dde806ff5561c27d5b9c8f4b17b", ANNA_BUTTFIELD, "renaming file1.txt to fil3.txt\n", "master", 1290658945000L, 2).next("26205817feaa5ecb2758e4be49cd3775790d0089", "25570b2d856c97716e119c4584bb7b2e65853bcf", ANNA_BUTTFIELD, "renaming fil3.txt to file3.txt\n", "master", 1290658967000L, 2).next("acc09cfb86f0a863e36949d8b3023301396fdf7b", "26205817feaa5ecb2758e4be49cd3775790d0089", ANNA_BUTTFIELD, "removing dir/file2.txt\n", "master", 1290659009000L, 1).next("f8970ceb0a3c65e4e1f45ad659afbac61e73c104", "acc09cfb86f0a863e36949d8b3023301396fdf7b", ANNA_BUTTFIELD, "copy file3.txt to file4.txt\n", "master", 1290660618000L, 1).next("1d428997406515884589ee900fe90561872d657e", "f8970ceb0a3c65e4e1f45ad659afbac61e73c104", ANNA_BUTTFIELD, "manual rename file4.txt to file5.txt\n", "master", 1290664001000L, 2).l());
    }

    protected void verifyMovedFilesWithRenameDetectionOn() throws Exception {
        this.assertRevisionData(DvcsRepoValidation.FileRevs.file("file1.txt").rev("554f718166e67dde806ff5561c27d5b9c8f4b17b", null, null, ANNA_BUTTFIELD, "initial commit\n", 1290658905000L, "master", DvcsRepoValidation.RevState.Added, "file1.txt", false, 1, 1, 0).rev("25570b2d856c97716e119c4584bb7b2e65853bcf", "554f718166e67dde806ff5561c27d5b9c8f4b17b", null, ANNA_BUTTFIELD, "renaming file1.txt to fil3.txt\n", 1290658945000L, "master", DvcsRepoValidation.RevState.Deleted, "file1.txt", false, 0, 0, 1));
        this.assertRevisionData(DvcsRepoValidation.FileRevs.file("fil3.txt").rev("25570b2d856c97716e119c4584bb7b2e65853bcf", "554f718166e67dde806ff5561c27d5b9c8f4b17b", null, ANNA_BUTTFIELD, "renaming file1.txt to fil3.txt\n", 1290658945000L, "master", DvcsRepoValidation.RevState.Renamed, "file1.txt", false, 1, 0, 0).rev("26205817feaa5ecb2758e4be49cd3775790d0089", "25570b2d856c97716e119c4584bb7b2e65853bcf", null, ANNA_BUTTFIELD, "renaming fil3.txt to file3.txt\n", 1290658967000L, "master", DvcsRepoValidation.RevState.Deleted, "fil3.txt", false, 0, 0, 1));
    }

    protected void verifyCopiedFilesWithCopyDetectionOn() throws Exception {
        this.assertRevisionData(DvcsRepoValidation.FileRevs.file("file4.txt").rev("f8970ceb0a3c65e4e1f45ad659afbac61e73c104", "26205817feaa5ecb2758e4be49cd3775790d0089", null, ANNA_BUTTFIELD, "copy file3.txt to file4.txt\n", 1290660618000L, "master", DvcsRepoValidation.RevState.Copied, "file3.txt", false, 1, 0, 0).rev("1d428997406515884589ee900fe90561872d657e", "f8970ceb0a3c65e4e1f45ad659afbac61e73c104", null, ANNA_BUTTFIELD, "manual rename file4.txt to file5.txt\n", 1290664001000L, "master", DvcsRepoValidation.RevState.Deleted, "file4.txt", false, 0, 0, 1));
    }

    protected void verifyCommitsWithRenameDetectionOff() throws Exception {
        this.assertCommitData(DvcsRepoValidation.Commits.first("554f718166e67dde806ff5561c27d5b9c8f4b17b", ANNA_BUTTFIELD, "initial commit\n", "master", 1290658905000L, 2).next("25570b2d856c97716e119c4584bb7b2e65853bcf", "554f718166e67dde806ff5561c27d5b9c8f4b17b", ANNA_BUTTFIELD, "renaming file1.txt to fil3.txt\n", "master", 1290658945000L, 2).next("26205817feaa5ecb2758e4be49cd3775790d0089", "25570b2d856c97716e119c4584bb7b2e65853bcf", ANNA_BUTTFIELD, "renaming fil3.txt to file3.txt\n", "master", 1290658967000L, 2).next("acc09cfb86f0a863e36949d8b3023301396fdf7b", "26205817feaa5ecb2758e4be49cd3775790d0089", ANNA_BUTTFIELD, "removing dir/file2.txt\n", "master", 1290659009000L, 1).next("f8970ceb0a3c65e4e1f45ad659afbac61e73c104", "acc09cfb86f0a863e36949d8b3023301396fdf7b", ANNA_BUTTFIELD, "copy file3.txt to file4.txt\n", "master", 1290660618000L, 1).next("1d428997406515884589ee900fe90561872d657e", "f8970ceb0a3c65e4e1f45ad659afbac61e73c104", ANNA_BUTTFIELD, "manual rename file4.txt to file5.txt\n", "master", 1290664001000L, 2).l());
    }

    protected void verifyMovedFilesWithRenameDetectionOff() throws Exception {
        this.assertRevisionData(DvcsRepoValidation.FileRevs.file("file1.txt").rev("554f718166e67dde806ff5561c27d5b9c8f4b17b", null, null, ANNA_BUTTFIELD, "initial commit\n", 1290658905000L, "master", DvcsRepoValidation.RevState.Added, "file1.txt", false, 1, 1, 0).rev("25570b2d856c97716e119c4584bb7b2e65853bcf", "554f718166e67dde806ff5561c27d5b9c8f4b17b", null, ANNA_BUTTFIELD, "renaming file1.txt to fil3.txt\n", 1290658945000L, "master", DvcsRepoValidation.RevState.Deleted, "file1.txt", false, 0, 0, 1));
        this.assertRevisionData(DvcsRepoValidation.FileRevs.file("fil3.txt").rev("25570b2d856c97716e119c4584bb7b2e65853bcf", null, null, ANNA_BUTTFIELD, "renaming file1.txt to fil3.txt\n", 1290658945000L, "master", DvcsRepoValidation.RevState.Added, "fil3.txt", false, 1, 1, 0).rev("26205817feaa5ecb2758e4be49cd3775790d0089", "25570b2d856c97716e119c4584bb7b2e65853bcf", null, ANNA_BUTTFIELD, "renaming fil3.txt to file3.txt\n", 1290658967000L, "master", DvcsRepoValidation.RevState.Deleted, "fil3.txt", false, 0, 0, 1));
    }

    protected void verifyCopiedFilesWithCopyDetectionOff() throws Exception {
        DvcsRepoValidation.Revision expected = new DvcsRepoValidation.Revision("file4.txt", "f8970ceb0a3c65e4e1f45ad659afbac61e73c104", (List<String>)NO_PARENTS, ANNA_BUTTFIELD, "copy file3.txt to file4.txt\n", 1290660618000L, "master", DvcsRepoValidation.RevState.Added, "file4.txt", false, 1, 1, 0);
        this.assertRevisionEquals(expected, ((GitCache)this.getCache()).getFileRevision(new RevInfoKey(new Path((CharSequence)"file4.txt"), "f8970ceb0a3c65e4e1f45ad659afbac61e73c104")));
    }
}

