/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git;

import com.atlassian.fisheye.git.GitCache;
import com.atlassian.fisheye.git.GitTestBase;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.Tag;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mozilla.javascript.edu.emory.mathcs.backport.java.util.Collections;

public class GitNonBranchTagTest
extends GitTestBase {
    public GitNonBranchTagTest() {
        super("unreftag");
    }

    @Test
    public void testTagPresent() throws Exception {
        GitCache cache = (GitCache)this.getCache();
        Tag t1 = cache.getTag("t1");
        junit.framework.Assert.assertNotNull((String)"Tag was not found", (Object)t1);
        Assert.assertEquals((String)"t2 tag incorrect", (Object)"10435458fa583a702f0633e9ab6eac7104c4ec57", (Object)t1.getChangesetId());
        Tag t2 = cache.getTag("t2");
        junit.framework.Assert.assertNotNull((String)"Tag was not found", (Object)t2);
        Assert.assertEquals((String)"t2 tag incorrect", (Object)"5e483c25825f1b1324fb798484175f7e26e083f4", (Object)t2.getChangesetId());
        FileHistory f1History = cache.getFileHistory(new Path((CharSequence)"d1/f1.txt"));
        Assert.assertEquals((String)"f1 should have revisions", (long)5L, (long)f1History.getRevisions().size());
        List<String> f1NonBranchRevisions = this.getNonBranchIds(f1History);
        junit.framework.Assert.assertEquals((String)"Incorrect number of non-branch revisions", (int)4, (int)f1NonBranchRevisions.size());
        FileHistory f2History = cache.getFileHistory(new Path((CharSequence)"d1/f2.txt"));
        Assert.assertEquals((String)"f2 should have a revision", (long)1L, (long)f2History.getRevisions().size());
        FileRevision revision = (FileRevision)f2History.getRevisions().iterator().next();
        Assert.assertEquals((String)"f2 should be tagged with t3", (Object)revision.getTags(), (Object)Collections.singletonList((Object)"t3"));
        List<String> f2NonBranchRevisions = this.getNonBranchIds(f2History);
        junit.framework.Assert.assertEquals((String)"Incorrect number of non-branch revisions", (int)1, (int)f2NonBranchRevisions.size());
    }

    private List<String> getNonBranchIds(FileHistory history) {
        ArrayList<String> nonBranchIds = new ArrayList<String>();
        for (FileRevision revision : history.getRevisions()) {
            if (revision.getBranch() != null) continue;
            nonBranchIds.add(revision.getChangeSetId());
        }
        return nonBranchIds;
    }
}

