/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git;

import com.atlassian.fisheye.git.GitCache;
import com.atlassian.fisheye.git.GitCommandlineTestBase;
import com.atlassian.fisheye.git.client.GitCommandBuilder;
import com.cenqua.fisheye.rep.Branch;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Test;

public class GitNoMasterTest
extends GitCommandlineTestBase {
    public GitNoMasterTest() {
        super(new GitCommandBuilder("init", new String[0]), new GitCommandBuilder("commit", new String[]{"-m", "initial commit", "--allow-empty"}), new GitCommandBuilder("checkout", new String[]{"-b", "second"}), new GitCommandBuilder("checkout", new String[]{"-b", "first"}), new GitCommandBuilder("branch", new String[]{"-D", "master"}));
    }

    @Test
    public void testIndexedProperly() throws Exception {
        GitCache cache = (GitCache)this.getCache();
        Set branches = cache.getBranches();
        String defaultBranch = cache.getDefaultBranch();
        String headCsid = (String)Iterables.getOnlyElement((Iterable)cache.getChangeSetIds());
        Assert.assertThat((Object)branches, (Matcher)Matchers.contains((Matcher[])new Matcher[]{this.branchWithCsid("first", headCsid), this.branchWithCsid("second", headCsid)}));
        Assert.assertThat((Object)defaultBranch, (Matcher)CoreMatchers.equalTo((Object)"first"));
    }

    private TypeSafeMatcher<Branch> branchWithCsid(final String name, final String csid) {
        return new TypeSafeMatcher<Branch>(){

            public void describeTo(Description description) {
                description.appendText("Branch ").appendText(name).appendText(" at ").appendText(csid);
            }

            protected boolean matchesSafely(Branch branch) {
                return Objects.equal((Object)branch.getName(), (Object)name) && Objects.equal((Object)branch.getLatestChangeSetId(), (Object)csid);
            }
        };
    }
}

