/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git;

import com.atlassian.fisheye.git.GitCache;
import com.atlassian.fisheye.git.GitTestBase;
import com.atlassian.fisheye.git.db.GitRevInfo;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.RevInfoKey;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class GitModifiedInMergeTest
extends GitTestBase {
    public GitModifiedInMergeTest() {
        super("modify-in-merge");
    }

    @Override
    public boolean isFlagWarnings() {
        return true;
    }

    @Test
    public void shouldNotPickTheWrongParent() throws Exception {
        GitRevInfo firstRev = (GitRevInfo)((GitCache)this.getCache()).getFileRevision(new RevInfoKey(new Path((CharSequence)"/foo"), "e6b17e4"));
        GitRevInfo mergeRev = (GitRevInfo)((GitCache)this.getCache()).getFileRevision(new RevInfoKey(new Path((CharSequence)"/foo"), "6f492a0"));
        GitRevInfo postMergeRev = (GitRevInfo)((GitCache)this.getCache()).getFileRevision(new RevInfoKey(new Path((CharSequence)"/foo"), "475253f"));
        Assert.assertThat((String)"Initial revision has 1 line", (Object)firstRev.getLineCount(), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat((String)"Initial revision blame should have 1 line", (Object)((GitCache)this.getCache()).getBlame(firstRev.getRevInfoKey()).getTotalLines(), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat((String)"Merge revision has an extra line added, should have 2", (Object)mergeRev.getLineCount(), (Matcher)Matchers.equalTo((Object)2));
        Assert.assertThat((String)"Merge revision blame should have 2 lines", (Object)((GitCache)this.getCache()).getBlame(mergeRev.getRevInfoKey()).getTotalLines(), (Matcher)Matchers.equalTo((Object)2));
        Assert.assertThat((String)"Remove the extra line, should now have just 1", (Object)postMergeRev.getLineCount(), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat((String)"After removing should have 1 line", (Object)((GitCache)this.getCache()).getBlame(postMergeRev.getRevInfoKey()).getTotalLines(), (Matcher)Matchers.equalTo((Object)1));
    }
}

