/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git;

import com.atlassian.fisheye.git.GitCache;
import com.atlassian.fisheye.git.GitTestBase;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class GitMailmapTest
extends GitTestBase {
    private final String MAILMAP_DIR = "mailmap/";
    private final String MAILMAP1 = "mailmap/mailmap1";
    private final String MAILMAP2 = "mailmap/mailmap2";
    private final String MAILMAP3 = "mailmap/mailmap3";
    private final String MAILMAP4 = "mailmap/mailmap4";

    @Test
    public void testAddingMailmap() throws Exception {
        this.slurpDump("mailmap/mailmap1");
        Set authors = ((GitCache)this.getCache()).getAllAuthors();
        Assert.assertEquals((String)"should only be one author after initial commit", (long)1L, (long)authors.size());
        this.slurpIncremental("mailmap/mailmap2");
        authors = ((GitCache)this.getCache()).getAllAuthors();
        Assert.assertEquals((String)"should be 2 authors after second commit", (long)2L, (long)authors.size());
        this.slurpIncremental("mailmap/mailmap3");
        authors = ((GitCache)this.getCache()).getAllAuthors();
        Assert.assertEquals((String)"should be 2 authors after third commit", (long)2L, (long)authors.size());
    }

    @Test
    public void testReindexWithMailmap() throws Exception {
        this.slurpDump("mailmap/mailmap3");
        Set authors = ((GitCache)this.getCache()).getAllAuthors();
        Assert.assertEquals((String)"should only be one author after a reindex", (long)1L, (long)authors.size());
    }

    @Test
    public void testModifyingMailmap() throws Exception {
        this.slurpDump("mailmap/mailmap3");
        Set authors = ((GitCache)this.getCache()).getAllAuthors();
        Assert.assertEquals((String)"should only be one author after a reindex", (long)1L, (long)authors.size());
        this.slurpIncremental("mailmap/mailmap4");
        authors = ((GitCache)this.getCache()).getAllAuthors();
        Assert.assertEquals((String)"should only be one author after fourth commit", (long)1L, (long)authors.size());
    }
}

