/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git;

import com.atlassian.fisheye.git.GitCache;
import com.atlassian.fisheye.git.GitTestBase;
import com.atlassian.fisheye.git.GitTestHarness;
import com.atlassian.fisheye.git.db.GitChangeSet;
import com.cenqua.fisheye.config.ConfigException;
import org.junit.Assert;
import org.junit.Test;

public class GitHttpAuthenticationTest
extends GitTestBase {
    private static final String URL_HTTPS = "bitbucket.org/fecrutest/git-auth.git";
    private static final String CORRECT_USERNAME = "fecrutest";
    private static final String CORRECT_PASSWORD = "h6i8LvUo";

    @Test
    public void testHttpsAuthenticationBadUsername() throws Exception {
        this.runExpectedFail("https", "wrong", CORRECT_PASSWORD, URL_HTTPS);
    }

    @Test
    public void testHttpsAuthenticationBadPassword() throws Exception {
        this.runExpectedFail("https", CORRECT_USERNAME, "wrong", URL_HTTPS);
    }

    @Test
    public void testHttpsAuthentication() throws Exception {
        this.runTest("https", CORRECT_USERNAME, CORRECT_PASSWORD, URL_HTTPS);
    }

    private void runExpectedFail(String protocol, String username, String password, String url) throws Exception {
        try {
            this.runTest(protocol, username, password, url);
        }
        catch (ConfigException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Unable to clone remote repository"));
            return;
        }
        Assert.fail((String)"Bad credentials didn't stop indexing");
    }

    private void runTest(String protocol, String username, String password, String url) throws Exception {
        ((GitTestHarness)this.testHarness).setPassword(password);
        this.slurpRemote(this.getUrl(protocol, username, url));
        ((GitTestHarness)this.testHarness).assertNoSlurpErrors("There were slurp errors");
        GitChangeSet changeset = (GitChangeSet)((GitCache)this.getCache()).getChangeSet("d7b920a56a2add3ec0a91f9095e6b8df6831b5a7");
        Assert.assertNotNull((Object)changeset);
        Assert.assertEquals((Object)"d7b920a56a2add3ec0a91f9095e6b8df6831b5a7", (Object)changeset.getId());
        Assert.assertEquals((long)2L, (long)changeset.getRevisionInfosCount());
    }

    private String getUrl(String protocol, String username, String url) {
        return protocol + "://" + username + "@" + url;
    }
}

