/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git;

import com.atlassian.fisheye.git.GitCache;
import com.atlassian.fisheye.git.GitRepositoryEngine;
import com.atlassian.fisheye.git.GitTestBase;
import com.atlassian.fisheye.git.GitTestHarness;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config1.AllowType;
import com.cenqua.fisheye.config1.RenameOptions;
import com.cenqua.fisheye.rep.BlameInfo;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.SyntheticBlameInfo;
import com.cenqua.fisheye.svn.BlameChunkMatcher;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class GitFE5660MissingBlameAfterMergeWithAncestryFromExcludedTest
extends GitTestBase {
    public static final Path PATH = new Path((CharSequence)"main/sub/foo");

    public GitFE5660MissingBlameAfterMergeWithAncestryFromExcludedTest() {
        super("move-merge-missing-blame");
    }

    @Override
    protected AllowType getAllowRules() {
        AllowType allow = AllowType.Factory.newInstance();
        AllowType.Exclude exclude = allow.addNewExclude();
        exclude.setPattern("side");
        return allow;
    }

    @Override
    protected RenameOptions.Enum getRenameDetection() {
        return RenameOptions.DETAILED;
    }

    @Test
    public void testBlameOnMoveRevision() throws Exception {
        RevInfoKey revision = new RevInfoKey(PATH, "ba84ee03f070f8d3aeacf88416b95130dd29a89d");
        int revId = ((GitCache)this.getCache()).getRevId(revision);
        List storedChunks = ((GitCache)this.getCache()).getCommonRevInfoDAO().getBlameSpans(revId);
        List cacheChunks = ((GitCache)this.getCache()).getBlame(revision).getChunks();
        Assert.assertThat((Object)storedChunks, (Matcher)Matchers.empty());
        Assert.assertThat((Object)cacheChunks, (Matcher)Matchers.contains((Matcher[])new Matcher[]{new BlameChunkMatcher(0, 1).withRevId(-1), new BlameChunkMatcher(1, 2).withRevId(revId), new BlameChunkMatcher(2, 3).withRevId(-1), new BlameChunkMatcher(3, 4).withRevId(-1), new BlameChunkMatcher(4, 5).withRevId(revId), new BlameChunkMatcher(5, 6).withRevId(-1), new BlameChunkMatcher(6, 8).withRevId(-1)}));
    }

    @Test
    public void testBlameOnMergeRevision() throws Exception {
        RevInfoKey revision = new RevInfoKey(PATH, "97415183eee9a4d9974a7e1808c5b1167c0c05c5");
        int revId = ((GitCache)this.getCache()).getRevId(revision);
        List storedChunks = ((GitCache)this.getCache()).getCommonRevInfoDAO().getBlameSpans(revId);
        List chunksInHistory = ((GitRepositoryEngine)((GitTestHarness)this.testHarness).getEngine()).getLinecountCalculator().getHistory(revision).getBlame();
        Assert.assertThat((Object)storedChunks, (Matcher)Matchers.contains((Matcher[])new Matcher[]{new BlameChunkMatcher(0, 2).withRevId(8).withBlameInfo(null), new BlameChunkMatcher(2, 4).withRevId(10).withBlameInfo(null), new BlameChunkMatcher(4, 5).withRevId(10).withBlameInfo(null), new BlameChunkMatcher(5, 8).withRevId(4).withBlameInfo(null), new BlameChunkMatcher(8, 9).withRevId(-1).withBlameInfo(null), new BlameChunkMatcher(9, 11).withRevId(8).withBlameInfo(null), new BlameChunkMatcher(11, 12).withRevId(-1).withBlameInfo(null), new BlameChunkMatcher(12, 13).withRevId(3).withBlameInfo(null), new BlameChunkMatcher(13, 14).withRevId(-1).withBlameInfo(null), new BlameChunkMatcher(14, 15).withRevId(5).withBlameInfo(null), new BlameChunkMatcher(15, 16).withRevId(5).withBlameInfo(null), new BlameChunkMatcher(16, 17).withRevId(6).withBlameInfo(null), new BlameChunkMatcher(17, 19).withRevId(10).withBlameInfo(null), new BlameChunkMatcher(19, 21).withRevId(9).withBlameInfo(null), new BlameChunkMatcher(21, 22).withRevId(9).withBlameInfo(null), new BlameChunkMatcher(22, 24).withRevId(7).withBlameInfo(null), new BlameChunkMatcher(24, 26).withRevId(4).withBlameInfo(null), new BlameChunkMatcher(26, 28).withRevId(7).withBlameInfo(null), new BlameChunkMatcher(28, 31).withRevId(4).withBlameInfo(null)}));
        Assert.assertThat((Object)chunksInHistory, (Matcher)Matchers.contains((Matcher[])new Matcher[]{new BlameChunkMatcher(0, 2).withRevId(8).withBlameInfo(new BlameInfo((FileRevision)((GitCache)this.getCache()).getFileRevision(8))), new BlameChunkMatcher(2, 4).withRevId(10).withBlameInfo(new BlameInfo((FileRevision)((GitCache)this.getCache()).getFileRevision(10))), new BlameChunkMatcher(4, 5).withRevId(10).withBlameInfo(new BlameInfo((FileRevision)((GitCache)this.getCache()).getFileRevision(10))), new BlameChunkMatcher(5, 8).withRevId(4).withBlameInfo(new BlameInfo((FileRevision)((GitCache)this.getCache()).getFileRevision(4))), new BlameChunkMatcher(8, 9).withRevId(-1).withBlameInfo((BlameInfo)new SyntheticBlameInfo("", "", PATH)), new BlameChunkMatcher(9, 11).withRevId(8).withBlameInfo(new BlameInfo((FileRevision)((GitCache)this.getCache()).getFileRevision(8))), new BlameChunkMatcher(11, 12).withRevId(-1).withBlameInfo((BlameInfo)new SyntheticBlameInfo("", "", PATH)), new BlameChunkMatcher(12, 13).withRevId(3).withBlameInfo(new BlameInfo((FileRevision)((GitCache)this.getCache()).getFileRevision(3))), new BlameChunkMatcher(13, 14).withRevId(-1).withBlameInfo((BlameInfo)new SyntheticBlameInfo("", "", PATH)), new BlameChunkMatcher(14, 15).withRevId(5).withBlameInfo(new BlameInfo((FileRevision)((GitCache)this.getCache()).getFileRevision(5))), new BlameChunkMatcher(15, 16).withRevId(5).withBlameInfo(new BlameInfo((FileRevision)((GitCache)this.getCache()).getFileRevision(5))), new BlameChunkMatcher(16, 17).withRevId(6).withBlameInfo(new BlameInfo((FileRevision)((GitCache)this.getCache()).getFileRevision(6))), new BlameChunkMatcher(17, 19).withRevId(10).withBlameInfo(new BlameInfo((FileRevision)((GitCache)this.getCache()).getFileRevision(10))), new BlameChunkMatcher(19, 21).withRevId(9).withBlameInfo(new BlameInfo((FileRevision)((GitCache)this.getCache()).getFileRevision(9))), new BlameChunkMatcher(21, 22).withRevId(9).withBlameInfo(new BlameInfo((FileRevision)((GitCache)this.getCache()).getFileRevision(9))), new BlameChunkMatcher(22, 24).withRevId(7).withBlameInfo(new BlameInfo((FileRevision)((GitCache)this.getCache()).getFileRevision(7))), new BlameChunkMatcher(24, 26).withRevId(4).withBlameInfo(new BlameInfo((FileRevision)((GitCache)this.getCache()).getFileRevision(4))), new BlameChunkMatcher(26, 28).withRevId(7).withBlameInfo(new BlameInfo((FileRevision)((GitCache)this.getCache()).getFileRevision(7))), new BlameChunkMatcher(28, 31).withRevId(4).withBlameInfo(new BlameInfo((FileRevision)((GitCache)this.getCache()).getFileRevision(4)))}));
    }
}

