/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git;

import com.atlassian.fisheye.dvcs.DvcsUtils;
import com.atlassian.fisheye.git.GitZippedCacheTestHarness;
import com.cenqua.crucible.util.UseTestSpringContextTestCase;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.BaseRevisionCache;
import com.cenqua.fisheye.rep.BlameInfo;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.SyntheticBlameInfo;
import com.cenqua.fisheye.svn.BlameChunkMatcher;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GitFE5660HandleMissingBlameInRuntimeTest
extends UseTestSpringContextTestCase {
    private GitZippedCacheTestHarness harness;
    private BaseRevisionCache<?, ?, ?> cache;

    @Before
    public void setUp() throws Exception {
        this.harness = new GitZippedCacheTestHarness("test/testfiles/git/caches/move-merge-missing-blame-pre-FE-5660.zip");
        this.harness.setRepoName("FE-5660");
        this.harness.createRepoDir();
        this.harness.createAndStartEngine();
        this.cache = this.harness.getCache();
    }

    @After
    public void tearDown() throws Exception {
        this.harness.cleanUp();
    }

    @Test
    public void getBlame_shouldFallbackForMangledBlame() throws Exception {
        RevInfoKey revision = new RevInfoKey(new Path((CharSequence)"main/sub/foo"), "ba84ee03f070f8d3aeacf88416b95130dd29a89d");
        int revId = this.cache.getRevId(revision);
        List storedChunks = this.cache.getCommonRevInfoDAO().getBlameSpans(revId);
        List cacheChunks = this.cache.getBlame(revision).getChunks();
        Assert.assertThat((String)"Stored chunks are broken", (Object)storedChunks, (Matcher)Matchers.contains((Matcher)new BlameChunkMatcher(0, -2).withRevId(revId)));
        Assert.assertThat((String)"Should fallback to the clone for chunks", (Object)cacheChunks, (Matcher)Matchers.contains((Matcher[])new Matcher[]{new BlameChunkMatcher(0, 1).withRevId(-1), new BlameChunkMatcher(1, 2).withRevId(revId), new BlameChunkMatcher(2, 3).withRevId(-1), new BlameChunkMatcher(3, 4).withRevId(-1), new BlameChunkMatcher(4, 5).withRevId(revId), new BlameChunkMatcher(5, 6).withRevId(-1), new BlameChunkMatcher(6, 8).withRevId(-1)}));
    }

    @Test
    public void getBlame_shouldReturnDummyRevisionsForNonExistantOnes() throws Exception {
        String cs = "97415183eee9a4d9974a7e1808c5b1167c0c05c5";
        Path path = new Path((CharSequence)"main/sub/foo");
        RevInfoKey revision = new RevInfoKey(path, "97415183eee9a4d9974a7e1808c5b1167c0c05c5");
        int revId = this.cache.getRevId(revision);
        int excludedChunkIdx = 4;
        int existingChunkIdx = 3;
        List storedChunks = this.cache.getCommonRevInfoDAO().getBlameSpans(revId);
        List cacheChunks = this.cache.getBlame(revision).getChunks();
        List fallbackChunks = this.cache.getBlameFallback(revision).getChunks();
        Assert.assertThat(storedChunks.get(3), (Matcher)new BlameChunkMatcher(5, 8).withRevId(4).withBlameInfo(null));
        Assert.assertThat(cacheChunks.get(3), (Matcher)new BlameChunkMatcher(5, 8).withRevId(4).withBlameInfo(new BlameInfo(this.cache.getFileRevision(4))));
        Assert.assertThat(fallbackChunks.get(3), (Matcher)new BlameChunkMatcher(5, 8).withRevId(4).withBlameInfo(new BlameInfo(this.cache.getFileRevision(4))));
        Assert.assertThat(storedChunks.get(4), (Matcher)new BlameChunkMatcher(8, 9).withRevId(-1).withBlameInfo(null));
        Assert.assertThat(cacheChunks.get(4), (Matcher)new BlameChunkMatcher(8, 9).withRevId(-1).withBlameInfo((BlameInfo)new SyntheticBlameInfo("", "", path)));
        String sourceRevision = "eaca0d25d13c984ba81c257dfe57642e0738a209";
        Assert.assertThat(fallbackChunks.get(4), (Matcher)new BlameChunkMatcher(8, 9).withRevId(-1).withBlameInfo((BlameInfo)new SyntheticBlameInfo("eaca0d25d13c984ba81c257dfe57642e0738a209", DvcsUtils.truncateHash((String)"eaca0d25d13c984ba81c257dfe57642e0738a209"), path)));
    }
}

