/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git;

import com.atlassian.fisheye.git.GitCache;
import com.atlassian.fisheye.git.GitTestBase;
import com.atlassian.fisheye.git.db.GitRevInfo;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config1.RenameOptions;
import com.cenqua.fisheye.rep.RevInfoKey;
import org.junit.Assert;
import org.junit.Test;

public class GitContentHashTest
extends GitTestBase {
    public GitContentHashTest() {
        super("content-hash");
    }

    @Override
    protected RenameOptions.Enum getRenameDetection() {
        return RenameOptions.DETAILED;
    }

    @Test
    public void testContentHashes() throws Exception {
        this.verifyCopies();
        this.vertifyMultipleFilesWithSameContentHashModifyOne();
        this.verifyChangeAndRevert();
    }

    private void verifyMarkedAsCopy(GitRevInfo original, GitRevInfo copy) throws Exception {
        Assert.assertTrue((String)"copy should be marked as a copy", (boolean)copy.isCopy());
        Assert.assertEquals((String)"the copy should have 1 parent that equals orginal", (long)1L, (long)copy.getAncestors().size());
        Assert.assertEquals((String)"the copy should have 1 parent that equals orginal", (Object)original.getRevInfoKey(), copy.getAncestors().get(0));
        Assert.assertEquals((String)"the copy's copy source must equal original", (Object)original.getRevInfoKey(), (Object)copy.getCopySource());
        Assert.assertTrue((String)"copy must be included in original's copy destinations", (boolean)original.getCopyDestinations().contains(copy.getRevInfoKey()));
    }

    private void verifyCopies() throws Exception {
        GitRevInfo example1 = (GitRevInfo)((GitCache)this.getCache()).getFileRevision(new RevInfoKey(new Path((CharSequence)"example1.txt"), "d7b920a56a2add3ec0a91f9095e6b8df6831b5a7"));
        Assert.assertNotNull((Object)example1);
        for (int i = 1; i <= 100; ++i) {
            GitRevInfo copy = (GitRevInfo)((GitCache)this.getCache()).getFileRevision(new RevInfoKey(new Path((CharSequence)("copy" + i + "-example1.txt")), "a8662b7811ef6faf54bfc5b26b23050e6e099260"));
            Assert.assertNotNull((Object)copy);
            Assert.assertEquals((String)("content hashes of example1.txt and " + copy.getPath() + " should be identical"), (Object)example1.getDestHash(), (Object)copy.getDestHash());
            this.verifyMarkedAsCopy(example1, copy);
        }
        GitRevInfo example2 = (GitRevInfo)((GitCache)this.getCache()).getFileRevision(new RevInfoKey(new Path((CharSequence)"example2.txt"), "d7b920a56a2add3ec0a91f9095e6b8df6831b5a7"));
        Assert.assertNotNull((Object)example2);
        GitRevInfo example1commit5 = (GitRevInfo)((GitCache)this.getCache()).getFileRevision(new RevInfoKey(new Path((CharSequence)"example1.txt"), "e8f83ad4eeac159dd980a166686f5a6ce36badf8"));
        GitRevInfo example1commit6 = (GitRevInfo)((GitCache)this.getCache()).getFileRevision(new RevInfoKey(new Path((CharSequence)"example1.txt"), "184dd1bda115c0fb43cf8b523f6d86a66c2c3e88"));
        Assert.assertNotNull((Object)example1commit5);
        Assert.assertNotNull((Object)example1commit6);
        Assert.assertEquals((String)"content hashes of example1.txt and example2.txt should be identical in commit 5", (Object)example2.getDestHash(), (Object)example1commit5.getDestHash());
        Assert.assertEquals((String)"content hashes of example1.txt and example2.txt should be identical in commit 6", (Object)example2.getDestHash(), (Object)example1commit6.getDestHash());
    }

    private void vertifyMultipleFilesWithSameContentHashModifyOne() throws Exception {
        GitRevInfo parent = (GitRevInfo)((GitCache)this.getCache()).getFileRevision(new RevInfoKey(new Path((CharSequence)"copy50-example1.txt"), "a8662b7811ef6faf54bfc5b26b23050e6e099260"));
        GitRevInfo modified = (GitRevInfo)((GitCache)this.getCache()).getFileRevision(new RevInfoKey(new Path((CharSequence)"copy50-example1.txt"), "467c8a01a52680d34b0c16a8f59d12fd631ab428"));
        Assert.assertNotNull((Object)parent);
        Assert.assertNotNull((Object)modified);
        Assert.assertEquals((String)"modified should have 1 parent that equals parent", (long)1L, (long)modified.getAncestors().size());
        Assert.assertEquals((String)"modified should have 1 parent that equals parent", (Object)parent.getRevInfoKey(), modified.getAncestors().get(0));
    }

    private void verifyChangeAndRevert() throws Exception {
        GitRevInfo parent = (GitRevInfo)((GitCache)this.getCache()).getFileRevision(new RevInfoKey(new Path((CharSequence)"copy50-example1.txt"), "467c8a01a52680d34b0c16a8f59d12fd631ab428"));
        GitRevInfo reverted = (GitRevInfo)((GitCache)this.getCache()).getFileRevision(new RevInfoKey(new Path((CharSequence)"copy50-example1.txt"), "578065259208f331a86ca54b11a6f4680a6422b7"));
        Assert.assertNotNull((Object)parent);
        Assert.assertNotNull((Object)reverted);
        Assert.assertEquals((String)"reverted should have 1 parent that equals parent", (long)1L, (long)reverted.getAncestors().size());
        Assert.assertEquals((String)"reverted should have 1 parent that equals parent", (Object)parent.getRevInfoKey(), reverted.getAncestors().get(0));
    }
}

