/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git;

import com.atlassian.fisheye.git.GitCache;
import com.atlassian.fisheye.git.GitTestBase;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.BranchState;
import com.google.common.base.Objects;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Test;

public class GitConflictingBranchNamesTest
extends GitTestBase {
    public GitConflictingBranchNamesTest() {
        super("nestedBranches-parentBranch");
    }

    @Test
    public void testConflictingBranch() throws Exception {
        Assert.assertThat((String)"Repo should be indexed by now", (Object)((GitCache)this.getCache()).isInitialCrucibleIndexingComplete(), (Matcher)Matchers.is((Object)Boolean.TRUE));
        Assert.assertThat((String)"Branch issue was already indexed", (Object)((GitCache)this.getCache()).getBranch("issue"), this.isBranch("issue", "bb482be74dc88e58a208850b3d4ca4dfd9953b2f", BranchState.ACTIVE));
        Assert.assertThat((String)"no nested branch yet", (Object)((GitCache)this.getCache()).getBranch("issue/someBranch"), (Matcher)Matchers.nullValue());
        this.slurpIncremental("nestedBranches-nestedBranch");
        Assert.assertThat((String)"Branch issue gets deleted", (Object)((GitCache)this.getCache()).getBranch("issue"), this.isBranch("issue", null, BranchState.REMOVED));
        Assert.assertThat((String)"And nested branch issue/someBranch gets fetched", (Object)((GitCache)this.getCache()).getBranch("issue/someIssue"), this.isBranch("issue/someIssue", "bb482be74dc88e58a208850b3d4ca4dfd9953b2f", BranchState.ACTIVE));
    }

    private Matcher<Branch> isBranch(final String name, final String csid, final BranchState state) {
        return new TypeSafeMatcher<Branch>(){

            protected boolean matchesSafely(Branch actual) {
                return Objects.equal((Object)actual.getName(), (Object)name) && Objects.equal((Object)actual.getLatestChangeSetId(), (Object)csid) && Objects.equal((Object)actual.getState(), (Object)state);
            }

            public void describeTo(Description description) {
                description.appendText("branch[name=").appendValue((Object)name).appendText(",csid=").appendValue((Object)csid).appendText(",state=").appendValue((Object)state).appendText(")");
            }
        };
    }
}

