/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git;

import com.atlassian.fisheye.dvcs.DvcsScmConfig;
import com.atlassian.fisheye.dvcs.client.DvcsCommandBuilder;
import com.atlassian.fisheye.git.GitScmConfig;
import com.atlassian.fisheye.git.GitTestBase;
import com.atlassian.fisheye.git.client.GitCommandBuilder;
import com.atlassian.fisheye.git.client.GitProcessFactory;
import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.LoggingProcessMonitor;
import com.atlassian.utils.process.ProcessHandler;
import com.atlassian.utils.process.ProcessMonitor;
import com.atlassian.utils.process.StringProcessHandler;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.util.Interval;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;

public abstract class GitCommandlineTestBase
extends GitTestBase {
    private static final Logger log = Logger.getLogger((String)"git");
    private final Iterable<GitCommandBuilder> gitCommands;
    private final ImmutableMap<String, String> gitEnvironment = ImmutableMap.builder().put((Object)"GIT_AUTHOR_NAME", (Object)this.getClass().getSimpleName()).put((Object)"GIT_AUTHOR_EMAIL", (Object)"test@test").put((Object)"GIT_COMMITTER_NAME", (Object)this.getClass().getSimpleName()).put((Object)"GIT_COMMITTER_EMAIL", (Object)"test@test").build();
    @Rule
    public TemporaryFolder tempDir = new TemporaryFolder();

    protected GitCommandlineTestBase(GitCommandBuilder ... gitCommands) {
        this.gitCommands = ImmutableList.copyOf((Object[])gitCommands);
    }

    @Override
    @Before
    public void slurpRepo() throws Exception {
        if (this.isTestEnabled()) {
            for (GitCommandBuilder gitCommand : this.gitCommands) {
                this.runCommand(gitCommand);
            }
            this.slurpRemote(this.tempDir.getRoot().getAbsolutePath());
        } else {
            log.info((Object)("Skipping tests in test class " + this.getClass().getName()));
        }
    }

    protected void runCommand(GitCommandBuilder gitCommand) throws IOException {
        StringProcessHandler handler = new StringProcessHandler();
        GitScmConfig config = (GitScmConfig)Mockito.mock(GitScmConfig.class);
        Mockito.when((Object)config.getRepositoryType()).thenReturn((Object)ScmType.GIT);
        Mockito.when((Object)config.getExecutable()).thenReturn((Object)this.getExecutable());
        Mockito.when((Object)config.getCommandTimeout()).thenReturn((Object)new Interval("30 seconds"));
        ExternalProcess process = ((GitProcessFactory)SpringContext.getComponentByClass(GitProcessFactory.class)).builder((DvcsScmConfig)config, (DvcsCommandBuilder)gitCommand, (ProcessHandler)handler, this.tempDir.getRoot()).monitor(new ProcessMonitor[]{new LoggingProcessMonitor(log, Priority.INFO, null)}).env(this.gitEnvironment).build();
        process.execute();
        if (!Strings.isNullOrEmpty((String)handler.getOutput())) {
            log.info((Object)handler.getOutput().trim());
        }
        if (!Strings.isNullOrEmpty((String)handler.getError())) {
            log.error((Object)handler.getError().trim());
        }
        Assert.assertThat((String)"Got errors setting up repository", (Object)handler.getExitCode(), (Matcher)Matchers.equalTo((Object)0));
    }
}

