/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git;

import com.atlassian.fisheye.git.GitCache;
import com.atlassian.fisheye.git.GitTestBase;
import com.cenqua.crucible.revision.diff.unified.HashMatchType;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionIdentifier;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class GitCacheTest
extends GitTestBase {
    private Map<Path, RevisionIdentifier> getRevisionIdMap(String path, String hash, HashMatchType matchtype) {
        HashMap<Path, RevisionIdentifier> identifiers = new HashMap<Path, RevisionIdentifier>();
        identifiers.put(new Path((CharSequence)path, true), new RevisionIdentifier(hash, matchtype));
        return identifiers;
    }

    private void assertRevisionResolved(String expected, Map<Path, String> actual) {
        Assert.assertEquals((String)("Expected 1 item in map, got " + actual.size()), (long)1L, (long)actual.size());
        String actualHash = actual.values().iterator().next();
        Assert.assertEquals((String)("Expected commit hash " + expected + " got " + actualHash), (Object)expected, (Object)actualHash);
    }

    @Test
    public void testResolveRevisionsForPatchUsingContentHashes() throws Exception {
        this.slurpDump("gitcachetest");
        Map resolvedHashes = ((GitCache)this.getCache()).resolveRevisionsForPatch(this.getRevisionIdMap("src/Test1.java", "227bdc7d9392d87fbc85d5c1bf7cabfd1439804a", HashMatchType.CONTENT));
        this.assertRevisionResolved("bcf417352098308fe014ac19f7396ea42f71f814", resolvedHashes);
        resolvedHashes = ((GitCache)this.getCache()).resolveRevisionsForPatch(this.getRevisionIdMap("src/Test2.java", "0028798cb1f0fa5ddd32a12b588c27d2c684c8fa", HashMatchType.CONTENT));
        this.assertRevisionResolved("bcf417352098308fe014ac19f7396ea42f71f814", resolvedHashes);
        resolvedHashes = ((GitCache)this.getCache()).resolveRevisionsForPatch(this.getRevisionIdMap("src/Test1.java", "ce20a5b72a82d2b3ee48ea92354ae9dfe612053b", HashMatchType.CONTENT));
        this.assertRevisionResolved("30d02aab43ac4646789c0922f9468fdd35ce96d0", resolvedHashes);
        resolvedHashes = ((GitCache)this.getCache()).resolveRevisionsForPatch(this.getRevisionIdMap("src/Test1.java", "4883431d315bacf67cf5c675e3fc2b3fb6a380f5", HashMatchType.CONTENT));
        this.assertRevisionResolved("65535e7ee4e6200b0b2b7d5d9e9a970d7f75e57e", resolvedHashes);
        resolvedHashes = ((GitCache)this.getCache()).resolveRevisionsForPatch(this.getRevisionIdMap("src/Test1.java", "dcd17886f95872abac4303ffd5f034cd546cbf79", HashMatchType.CONTENT));
        this.assertRevisionResolved("ae80827f7dd608bd49dacbca0b9d65f795507141", resolvedHashes);
        resolvedHashes = ((GitCache)this.getCache()).resolveRevisionsForPatch(this.getRevisionIdMap("src/Test1.java", "89a762b4dcd1c6294b40ecd943e6110ae70b2821", HashMatchType.CONTENT));
        this.assertRevisionResolved("f3f7a8131fa8b020daf012a6c479cd48a02b86ac", resolvedHashes);
        resolvedHashes = ((GitCache)this.getCache()).resolveRevisionsForPatch(this.getRevisionIdMap("src/Test1.java", "4ae871086a2ab648d74b7f73f6a95b8e6d231c8f", HashMatchType.CONTENT));
        this.assertRevisionResolved("c099237214ea09310120163ce53bba5e5e3dc77a", resolvedHashes);
        resolvedHashes = ((GitCache)this.getCache()).resolveRevisionsForPatch(this.getRevisionIdMap("src/Test1.java", "f64af603aeb34999aba4981b244de27cc9415469", HashMatchType.CONTENT));
        this.assertRevisionResolved("53aa325d92bd6b386340a90c0d7c42454d299949", resolvedHashes);
        resolvedHashes = ((GitCache)this.getCache()).resolveRevisionsForPatch(this.getRevisionIdMap("src/Test2.java", "274c44900e21f53d231ab4245edd3b69e7978758", HashMatchType.CONTENT));
        this.assertRevisionResolved("78578924a2663c81e755680e90a3ba2b7ce2c70d", resolvedHashes);
    }

    @Test
    public void testResolveRevisionsForPatchUsingCommitHashes() throws Exception {
        this.slurpDump("gitcachetest");
        Map resolvedHashes = ((GitCache)this.getCache()).resolveRevisionsForPatch(this.getRevisionIdMap("src/Test1.java", "bcf417352098308fe014ac19f7396ea42f71f814", HashMatchType.COMMIT));
        this.assertRevisionResolved("bcf417352098308fe014ac19f7396ea42f71f814", resolvedHashes);
        resolvedHashes = ((GitCache)this.getCache()).resolveRevisionsForPatch(this.getRevisionIdMap("src/Test2.java", "bcf417352098308fe014ac19f7396ea42f71f814", HashMatchType.COMMIT));
        this.assertRevisionResolved("bcf417352098308fe014ac19f7396ea42f71f814", resolvedHashes);
        resolvedHashes = ((GitCache)this.getCache()).resolveRevisionsForPatch(this.getRevisionIdMap("src/Test1.java", "30d02aab43ac4646789c0922f9468fdd35ce96d0", HashMatchType.COMMIT));
        this.assertRevisionResolved("30d02aab43ac4646789c0922f9468fdd35ce96d0", resolvedHashes);
        resolvedHashes = ((GitCache)this.getCache()).resolveRevisionsForPatch(this.getRevisionIdMap("src/Test2.java", "30d02aab43ac4646789c0922f9468fdd35ce96d0", HashMatchType.COMMIT));
        this.assertRevisionResolved("bcf417352098308fe014ac19f7396ea42f71f814", resolvedHashes);
        resolvedHashes = ((GitCache)this.getCache()).resolveRevisionsForPatch(this.getRevisionIdMap("src/Test1.java", "65535e7ee4e6200b0b2b7d5d9e9a970d7f75e57e", HashMatchType.COMMIT));
        this.assertRevisionResolved("65535e7ee4e6200b0b2b7d5d9e9a970d7f75e57e", resolvedHashes);
        resolvedHashes = ((GitCache)this.getCache()).resolveRevisionsForPatch(this.getRevisionIdMap("src/Test2.java", "65535e7ee4e6200b0b2b7d5d9e9a970d7f75e57e", HashMatchType.COMMIT));
        this.assertRevisionResolved("bcf417352098308fe014ac19f7396ea42f71f814", resolvedHashes);
        resolvedHashes = ((GitCache)this.getCache()).resolveRevisionsForPatch(this.getRevisionIdMap("src/Test1.java", "ae80827f7dd608bd49dacbca0b9d65f795507141", HashMatchType.COMMIT));
        this.assertRevisionResolved("ae80827f7dd608bd49dacbca0b9d65f795507141", resolvedHashes);
        resolvedHashes = ((GitCache)this.getCache()).resolveRevisionsForPatch(this.getRevisionIdMap("src/Test2.java", "ae80827f7dd608bd49dacbca0b9d65f795507141", HashMatchType.COMMIT));
        this.assertRevisionResolved("bcf417352098308fe014ac19f7396ea42f71f814", resolvedHashes);
        resolvedHashes = ((GitCache)this.getCache()).resolveRevisionsForPatch(this.getRevisionIdMap("src/Test1.java", "f3f7a8131fa8b020daf012a6c479cd48a02b86ac", HashMatchType.COMMIT));
        this.assertRevisionResolved("f3f7a8131fa8b020daf012a6c479cd48a02b86ac", resolvedHashes);
        resolvedHashes = ((GitCache)this.getCache()).resolveRevisionsForPatch(this.getRevisionIdMap("src/Test2.java", "f3f7a8131fa8b020daf012a6c479cd48a02b86ac", HashMatchType.COMMIT));
        this.assertRevisionResolved("bcf417352098308fe014ac19f7396ea42f71f814", resolvedHashes);
        resolvedHashes = ((GitCache)this.getCache()).resolveRevisionsForPatch(this.getRevisionIdMap("src/Test1.java", "c099237214ea09310120163ce53bba5e5e3dc77a", HashMatchType.COMMIT));
        this.assertRevisionResolved("c099237214ea09310120163ce53bba5e5e3dc77a", resolvedHashes);
        resolvedHashes = ((GitCache)this.getCache()).resolveRevisionsForPatch(this.getRevisionIdMap("src/Test2.java", "c099237214ea09310120163ce53bba5e5e3dc77a", HashMatchType.COMMIT));
        this.assertRevisionResolved("bcf417352098308fe014ac19f7396ea42f71f814", resolvedHashes);
        resolvedHashes = ((GitCache)this.getCache()).resolveRevisionsForPatch(this.getRevisionIdMap("src/Test1.java", "53aa325d92bd6b386340a90c0d7c42454d299949", HashMatchType.COMMIT));
        this.assertRevisionResolved("53aa325d92bd6b386340a90c0d7c42454d299949", resolvedHashes);
        resolvedHashes = ((GitCache)this.getCache()).resolveRevisionsForPatch(this.getRevisionIdMap("src/Test2.java", "53aa325d92bd6b386340a90c0d7c42454d299949", HashMatchType.COMMIT));
        this.assertRevisionResolved("bcf417352098308fe014ac19f7396ea42f71f814", resolvedHashes);
        resolvedHashes = ((GitCache)this.getCache()).resolveRevisionsForPatch(this.getRevisionIdMap("src/Test1.java", "78578924a2663c81e755680e90a3ba2b7ce2c70d", HashMatchType.COMMIT));
        this.assertRevisionResolved("c099237214ea09310120163ce53bba5e5e3dc77a", resolvedHashes);
        resolvedHashes = ((GitCache)this.getCache()).resolveRevisionsForPatch(this.getRevisionIdMap("src/Test2.java", "78578924a2663c81e755680e90a3ba2b7ce2c70d", HashMatchType.COMMIT));
        this.assertRevisionResolved("78578924a2663c81e755680e90a3ba2b7ce2c70d", resolvedHashes);
        resolvedHashes = ((GitCache)this.getCache()).resolveRevisionsForPatch(this.getRevisionIdMap("src/Test1.java", "30cca3b3d6ab20aaeea7b2984236fa1f6b11af32", HashMatchType.COMMIT));
        this.assertRevisionResolved("53aa325d92bd6b386340a90c0d7c42454d299949", resolvedHashes);
        resolvedHashes = ((GitCache)this.getCache()).resolveRevisionsForPatch(this.getRevisionIdMap("src/Test2.java", "30cca3b3d6ab20aaeea7b2984236fa1f6b11af32", HashMatchType.COMMIT));
        this.assertRevisionResolved("78578924a2663c81e755680e90a3ba2b7ce2c70d", resolvedHashes);
    }
}

