/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git;

import com.atlassian.fisheye.git.GitCache;
import com.atlassian.fisheye.git.GitTestBase;
import com.atlassian.fisheye.git.db.GitChangeSet;
import java.util.Arrays;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;

public class GitBranchMoveTest
extends GitTestBase {
    private static final String CS0 = "2f9ed1abdc51d35f17497ee865cc610e39b52a5d";
    private static final String CS1 = "b323ae870ba33130509fe94e1c5bfcdb6d2fc59f";
    private static final String CS2 = "d8c1a202e6161bcf76d8696f96ede6501cbe0cbe";

    private void assertBranches(String csId, String ... branches) throws Exception {
        GitChangeSet cs = (GitChangeSet)((GitCache)this.getCache()).getChangeSet(csId);
        Assert.assertNotNull((Object)cs);
        HashSet<String> expectedBranches = new HashSet<String>(Arrays.asList(branches));
        Assert.assertEquals((String)("branches don't match for cs " + csId), expectedBranches, (Object)cs.getBranches());
    }

    @Test
    public void testBranchMove() throws Exception {
        this.slurpDump("branch-move");
        this.assertBranches(CS0, "master", "left", "right");
        this.assertBranches(CS1, "left");
        this.assertBranches(CS2, "right");
        this.slurpIncremental("branch-move-2");
        this.assertBranches(CS0, "master", "left", "right", "new_left");
        this.assertBranches(CS1, "new_left");
        this.assertBranches(CS2, "right", "left");
    }
}

