/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git;

import com.atlassian.fecru.search.index.service.DocInfoManager;
import com.atlassian.fisheye.git.GitCache;
import com.atlassian.fisheye.git.GitTestBase;
import com.atlassian.fisheye.git.db.GitChangeSet;
import com.atlassian.fugue.Option;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.crossrepo.BranchDocInfo;
import com.cenqua.fisheye.crossrepo.BranchQueryBuilder;
import com.cenqua.fisheye.crossrepo.ChangesetQueryBuilder;
import com.cenqua.fisheye.csindex.ChangesetIndexer;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.BranchState;
import com.cenqua.fisheye.rep.ChangeSetImpl;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.TopDocs;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class GitBranchDeleteTest
extends GitTestBase {
    public static final String DELETED_BRANCH_NAME = "testbranch";
    public static final String DELETED_BRANCH_HEAD = "c8bb55829e3d96762846ee8712ed15c50fc89366";
    public static final String MASTER_HEAD = "da016c75ccf25171caf50f15c194fa0911318c93";
    public static final String NOT_A_CSID_IN_REPO = "ffffffffffffffffffffffffffffffffffffffffff";

    public GitBranchDeleteTest() {
        super("branchdeletestart");
    }

    @Test
    public void testBranchDeletion() throws Exception {
        Set branches = ((GitCache)this.getCache()).getBranches();
        Assert.assertEquals((String)"Did not find required branches", (long)2L, (long)branches.size());
        junit.framework.Assert.assertNotNull((String)"Did not contain expected branch", (Object)((GitCache)this.getCache()).getBranch(DELETED_BRANCH_NAME));
        Assert.assertThat((Object)((GitChangeSet)((GitCache)this.getCache()).getChangeSet(DELETED_BRANCH_HEAD)).getBranchesContributedTo(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{DELETED_BRANCH_NAME}));
        Assert.assertThat((Object)((GitChangeSet)((GitCache)this.getCache()).getChangeSet(MASTER_HEAD)).getBranchesContributedTo(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{DELETED_BRANCH_NAME, "master"}));
        this.slurpIncremental("branchdeleteinc");
        branches = ((GitCache)this.getCache()).getBranches();
        Assert.assertEquals((String)"Did not find required # branches in cache", (long)1L, (long)Sets.filter((Set)branches, (Predicate)Branch.NOT_REMOVED).size());
        Assert.assertEquals((String)"Branch should be marked as removed in cache", (Object)BranchState.REMOVED, (Object)((GitCache)this.getCache()).getBranch(DELETED_BRANCH_NAME).getState());
        ((GitCache)this.getCache()).getCrossRepoIndex().getConnection().withIndexSearcher((LuceneConnection.IndexConfig)CrossRepLuceneIndexes.METADATA, indexSearcher -> {
            TopDocs indexBranches = indexSearcher.search(BranchQueryBuilder.newInstance().inAnyState().withAnyStringInName(Collections.singleton(DELETED_BRANCH_NAME)).build(), 1);
            Assert.assertEquals((String)"Branch should be in index", (long)1L, (long)indexBranches.totalHits);
            Assert.assertEquals((String)"Branch should be marked deleted in index", (Object)BranchState.REMOVED.getValue(), (Object)BranchDocInfo.fromDocumentToBranchDocInfo((Document)indexSearcher.doc(indexBranches.scoreDocs[0].doc)).getBranchState());
            return null;
        });
        Assert.assertThat((Object)((GitChangeSet)((GitCache)this.getCache()).getChangeSet(DELETED_BRANCH_HEAD)).getBranchesContributedTo(), (Matcher)Matchers.empty());
        Assert.assertThat((Object)((GitChangeSet)((GitCache)this.getCache()).getChangeSet(MASTER_HEAD)).getBranchesContributedTo(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"master"}));
    }

    @Test
    public void testBranchDeletion_branchAlreadyPruned() throws Exception {
        Branch prunedBranch = new Branch("pruned", NOT_A_CSID_IN_REPO, BranchState.ACTIVE);
        prunedBranch.setLatestMarkedChangesetId(Option.some((Object)NOT_A_CSID_IN_REPO));
        ((GitCache)this.getCache()).storeBranch(prunedBranch);
        this.indexMockChangesetOnBranch(NOT_A_CSID_IN_REPO, prunedBranch.getName());
        ((GitCache)this.getCache()).getChangeSetDAO().markAsAncestorOfBranch(NOT_A_CSID_IN_REPO, prunedBranch.getName());
        ((GitCache)this.getCache()).getChangeSetDAO().markAsAncestorOfBranch(DELETED_BRANCH_HEAD, prunedBranch.getName());
        ((GitCache)this.getCache()).getChangeSetDAO().markAsAncestorOfBranch(MASTER_HEAD, prunedBranch.getName());
        ((GitCache)this.getCache()).commit();
        this.slurpIncremental("branchdeleteinc");
        Branch afterSlurpPrunedBranch = ((GitCache)this.getCache()).getBranch(prunedBranch.getName());
        Assert.assertThat((Object)((GitChangeSet)((GitCache)this.getCache()).getChangeSet(DELETED_BRANCH_HEAD)).getBranchesContributedTo(), (Matcher)Matchers.not((Matcher)Matchers.contains((Object[])new String[]{prunedBranch.getName()})));
        Assert.assertThat((Object)((GitChangeSet)((GitCache)this.getCache()).getChangeSet(DELETED_BRANCH_HEAD)).getBranchesContributedTo(), (Matcher)Matchers.not((Matcher)Matchers.contains((Object[])new String[]{prunedBranch.getName()})));
        Assert.assertThat((Object)((GitChangeSet)((GitCache)this.getCache()).getChangeSet(MASTER_HEAD)).getBranchesContributedTo(), (Matcher)Matchers.not((Matcher)Matchers.contains((Object[])new String[]{prunedBranch.getName()})));
        Assert.assertThat((Object)afterSlurpPrunedBranch.getState(), (Matcher)Matchers.equalTo((Object)BranchState.REMOVED));
        Assert.assertThat((Object)afterSlurpPrunedBranch.getLatestChangeSetId(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)afterSlurpPrunedBranch.getLatestMarkedChangesetId(), (Matcher)Matchers.equalTo((Object)Option.none()));
        ((GitCache)this.getCache()).getCrossRepoIndex().getConnection().withIndexSearcher((LuceneConnection.IndexConfig)CrossRepLuceneIndexes.METADATA, searcher -> {
            TopDocs changesetsOnBranch = searcher.search(ChangesetQueryBuilder.newBuilder((String)((GitCache)this.getCache()).getRepositoryName()).changesetsOnly().onBranch(prunedBranch.getName()).build(), 10);
            Assert.assertThat((Object)changesetsOnBranch.totalHits, (Matcher)Matchers.equalTo((Object)0));
            List branches = new DocInfoManager(null, searcher.getIndexReader()).findDocs(BranchQueryBuilder.newInstance().inAnyState().withPrefix(prunedBranch.getName()).build(), BranchDocInfo.CONVERTER, 10);
            Assert.assertThat((Object)branches, (Matcher)Matchers.hasSize((int)1));
            Assert.assertThat((Object)((BranchDocInfo)branches.get(0)).getBranchState(), (Matcher)Matchers.equalTo((Object)BranchState.REMOVED.getValue()));
            Assert.assertThat((Object)((BranchDocInfo)branches.get(0)).getLastChangeSetId(), (Matcher)Matchers.nullValue());
            return null;
        });
    }

    private void indexMockChangesetOnBranch(String csid, String branch) throws LicensePolicyException {
        GitChangeSet fakeCs = new GitChangeSet(csid, ((GitCache)this.getCache()).getChangeSetDAO(), ((GitCache)this.getCache()).getFileRevisionDAO());
        fakeCs.setAuthor("author");
        fakeCs.setComment("already removed from git repo");
        fakeCs.setParents((Iterable)ImmutableSet.of((Object)DELETED_BRANCH_HEAD));
        fakeCs.setRepName(((GitCache)this.getCache()).getRepositoryName());
        fakeCs.setBranchesContributedTo(Collections.singletonList(branch));
        ((GitCache)this.getCache()).getChangeSetDAO().store((ChangeSetImpl)fakeCs);
        new ChangesetIndexer().indexChangesetsAndAuthors(((GitCache)this.getCache()).getCrossRepLuceneConnection(), Collections.singleton(fakeCs).iterator(), new RepositoryStatus(""), false, (Collection)Lists.newArrayList(), false);
    }
}

