/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git;

import com.atlassian.fisheye.git.GitCache;
import com.atlassian.fisheye.git.GitTestBase;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config1.RenameOptions;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import junit.framework.Assert;
import org.junit.Test;

public class GitBinaryTest
extends GitTestBase {
    public GitBinaryTest() {
        super("gitbinary");
    }

    @Override
    protected RenameOptions.Enum getRenameDetection() {
        return RenameOptions.DETAILED;
    }

    @Test
    public void testBinaryDetection() throws DbException {
        GitCache cache = (GitCache)this.getCache();
        FileHistory history = cache.getFileHistory(new Path((CharSequence)"binary/image.png"));
        FileRevision revision = history.getRevision("92ee357a57730aa2f6bbcf1add32114eae66956d");
        Assert.assertTrue((String)"Initial revision should be binary", (boolean)revision.isBinary());
        revision = history.getRevision("3d995f83b9c169e7dff2c9157fc46dfc4128297d");
        Assert.assertTrue((String)"Modified revision should be binary", (boolean)revision.isBinary());
        revision = history.getRevision("cc5e9d118a71709eecec512fbbee455b4ad7f621");
        Assert.assertTrue((String)"Moved revision should be deleted", (revision != null && revision.isDead() ? 1 : 0) != 0);
        history = cache.getFileHistory(new Path((CharSequence)"binary/newimage.png"));
        revision = history.getRevision("cc5e9d118a71709eecec512fbbee455b4ad7f621");
        Assert.assertTrue((String)"Moved revision should be binary", (boolean)revision.isBinary());
        history = cache.getFileHistory(new Path((CharSequence)"binary/new2.png"));
        revision = history.getRevision("a8a694fb6a5899775cca373e349baf64c73808a8");
        Assert.assertTrue((String)"Copied revision should be binary", (boolean)revision.isBinary());
    }
}

