/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git;

import com.atlassian.fecru.search.index.service.DocInfoManager;
import com.atlassian.fisheye.git.GitCache;
import com.atlassian.fisheye.git.GitTestBase;
import com.atlassian.fisheye.git.db.GitChangeSet;
import com.atlassian.fisheye.git.db.GitChangeSetDAO;
import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.crossrepo.ChangesetDocInfo;
import com.cenqua.fisheye.crossrepo.ChangesetQueryBuilder;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.ChangeSet;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class GitBatchedReindexingTest
extends GitTestBase {
    private static final String STEP1_REPO = "gitbackindexing-step1";
    private static final String STEP2_REPO = "gitbackindexing-step2";
    private static final String BRANCH_MASTER = "master";
    private static final String BRANCH_ON_MASTER_200 = "branch-on-master-200";
    private static final String BRANCH_ON_MASTER_0 = "branch-on-master-0";

    public GitBatchedReindexingTest() {
        super(STEP1_REPO);
    }

    @Test
    public void onNewBranchScanNewCommitsAndFirstBatchOfModifiedAreIndexed() throws Exception {
        GitChangeSetDAO dao = ((GitCache)this.getCache()).getChangeSetDAO();
        this.setBackindexingTimeLimit(0);
        this.slurpIncremental(STEP2_REPO);
        ImmutableList onMaster = ImmutableList.copyOf((Iterable)dao.getChangeSetsInAncestryOfBranch(BRANCH_MASTER));
        ImmutableList onBranch0 = ImmutableList.copyOf((Iterable)dao.getChangeSetsInAncestryOfBranch(BRANCH_ON_MASTER_0));
        ImmutableList onBranch200 = ImmutableList.copyOf((Iterable)dao.getChangeSetsInAncestryOfBranch(BRANCH_ON_MASTER_200));
        Assert.assertThat((Object)onMaster, (Matcher)Matchers.allOf((Matcher)Matchers.iterableWithSize((int)201), (Matcher)Matchers.everyItem(this.isInBranch(BRANCH_MASTER)), (Matcher)Matchers.everyItem(this.isInBranch(BRANCH_ON_MASTER_200)), (Matcher)Matchers.everyItem(this.isInBranch(BRANCH_ON_MASTER_0))));
        Assert.assertThat((Object)onBranch0, (Matcher)Matchers.equalTo((Object)onMaster));
        Assert.assertThat((Object)onBranch200, (Matcher)Matchers.hasSize((int)401));
        this.assertChangesetsIndexedOnBranch(Lists.reverse((List)onBranch200).subList(0, 300), BRANCH_ON_MASTER_200);
        this.assertChangesetsIndexedOnBranch(Lists.reverse((List)onMaster).subList(0, 100), BRANCH_ON_MASTER_0);
    }

    @Test
    public void allNewCommitsIndexedIfNoTimeout() throws Exception {
        GitChangeSetDAO dao = ((GitCache)this.getCache()).getChangeSetDAO();
        this.setBackindexingTimeLimit(Integer.MAX_VALUE);
        this.slurpIncremental(STEP2_REPO);
        ImmutableList onBranch0 = ImmutableList.copyOf((Iterable)dao.getChangeSetsInAncestryOfBranch(BRANCH_ON_MASTER_0));
        ImmutableList onBranch200 = ImmutableList.copyOf((Iterable)dao.getChangeSetsInAncestryOfBranch(BRANCH_ON_MASTER_200));
        this.assertChangesetsIndexedOnBranch((List<GitChangeSet>)onBranch200, BRANCH_ON_MASTER_200);
        this.assertChangesetsIndexedOnBranch((List<GitChangeSet>)onBranch0, BRANCH_ON_MASTER_0);
    }

    private void setBackindexingTimeLimit(int limitSeconds) {
        FishEyeSysProps.GIT_SCANNED_CHANGESET_INDEXING_TIMELIMIT_SECONDS = limitSeconds;
    }

    private void assertChangesetsIndexedOnBranch(List<GitChangeSet> expected, String branch) {
        ((GitCache)this.getCache()).getCrossRepLuceneConnection().withIndexReader((LuceneConnection.IndexConfig)CrossRepLuceneIndexes.METADATA, reader -> {
            DocInfoManager docMan = new DocInfoManager(null, reader);
            ImmutableList indexedOnBranch200 = ImmutableList.copyOf((Collection)docMan.findDocs(ChangesetQueryBuilder.newBuilder((String)STEP1_REPO).onBranch(branch).build(), ChangesetDocInfo.CONVERTER_CSID_ONLY, Integer.MAX_VALUE));
            Assert.assertThat((Object)indexedOnBranch200, (Matcher)Matchers.hasSize((int)expected.size()));
            Assert.assertThat((Object)indexedOnBranch200, (Matcher)Matchers.everyItem((Matcher)Matchers.isIn(this.csids(expected))));
            return null;
        });
    }

    private List<String> csids(List<GitChangeSet> changesets) {
        return Lists.transform(changesets, (Function)ChangeSet.TO_CSID);
    }

    private Matcher<GitChangeSet> isInBranch(final String branch) {
        return new TypeSafeMatcher<GitChangeSet>(){

            protected boolean matchesSafely(GitChangeSet cs) {
                return cs.getBranches().contains(branch);
            }

            public void describeTo(Description description) {
                description.appendText("a changeset on branch " + branch);
            }
        };
    }

    @After
    public void tearDown() throws Exception {
        FishEyeSysProps.reloadProperties();
    }
}

