/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git;

import com.atlassian.fisheye.git.GitCache;
import com.atlassian.fisheye.git.GitTestBase;
import com.atlassian.fisheye.git.db.GitRevInfo;
import com.atlassian.fisheye.rep.RevCountChecker;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileHistory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;

public class GitBasicSlurpTest
extends GitTestBase {
    public GitBasicSlurpTest() {
        super("basic");
    }

    @Override
    protected int getBlockSize() {
        return 2;
    }

    @Test
    public void testBasic() throws DbException, IOException {
        GitCache cache = (GitCache)this.getCache();
        FileHistory f1History = cache.getFileHistory(new Path((CharSequence)"d1/f1.txt"));
        Assert.assertEquals((String)"Incorrect history size", (long)2L, (long)f1History.getRevisions().size());
        Iterator iter = f1History.getRevisions().iterator();
        GitRevInfo rev1 = (GitRevInfo)iter.next();
        GitRevInfo rev2 = (GitRevInfo)iter.next();
        Assert.assertEquals((String)"1st Commit message incorrect", (Object)"Initial Commit", (Object)rev1.getComment().trim());
        Assert.assertEquals((String)"2nd Commit message incorrect", (Object)"Change file", (Object)rev2.getComment().trim());
        Assert.assertEquals((String)"Author 1 incorrect", (Object)"Conor MacNeill", (Object)rev1.getRawAuthor());
        Assert.assertEquals((String)"Author 2 incorrect", (Object)"Conor MacNeill", (Object)rev2.getRawAuthor());
        Assert.assertEquals((String)"Email 1 incorrect", (Object)"conor@awali.sydney.atlassian.com", (Object)rev1.getEmail());
        Assert.assertEquals((String)"Email 2 incorrect", (Object)"conor@awali.sydney.atlassian.com", (Object)rev2.getEmail());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        cache.getTextRevision(rev1.getRevInfoKey(), (OutputStream)baos, null, null);
        baos.close();
        Assert.assertEquals((String)"Rev 1 content mismatch", (Object)"New File\n", (Object)baos.toString());
        baos = new ByteArrayOutputStream();
        cache.getTextRevision(rev2.getRevInfoKey(), (OutputStream)baos, null, null);
        baos.close();
        Assert.assertEquals((String)"Rev 2 content mismatch", (Object)"New File\nSecond Line\n", (Object)baos.toString());
    }

    @Test
    public void testRevCounts() {
        RevCountChecker.checkRevCounts(this.getCache());
    }
}

