/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.dvcs.db;

import com.atlassian.fisheye.dvcs.db.DvcsChangeSetDAO;
import com.atlassian.fisheye.dvcs.db.DvcsRevInfo;
import com.atlassian.fisheye.dvcs.db.DvcsRevInfoDAO;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.UniqueStringTableFactory;
import com.cenqua.fisheye.rep.ChangeSetImpl;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.List;

public class TestDvcsChangeSetDAO
extends DvcsChangeSetDAO<TestDvcsRevInfo, TestDvcsChangeSet, TestDvcsStringTables> {
    public static final String CS3 = "cs3456789abd";
    public static final String CS2 = "cs23456789ab";
    public static final String CS1 = "cs123456789a";
    public static final String CS0 = "cs0123456789";

    public TestDvcsChangeSetDAO(RepositoryStatus status, InfinityDbHandle dbh, TestDvcsStringTables stringTables, DvcsRevInfoDAO fileRevDAO, LicenseEnforcer licenseEnforcer) {
        super(status, dbh, (CommonStringTables)stringTables, fileRevDAO, licenseEnforcer);
    }

    public TestDvcsChangeSet createChangeSet(String csid) {
        return new TestDvcsChangeSet(csid);
    }

    public static File getInfDBTestFile(String name) throws IOException {
        File dbFile = File.createTempFile("infdbtest", name);
        if (dbFile.exists() && !dbFile.delete()) {
            dbFile.deleteOnExit();
            throw new RuntimeException("Could not delete test database file " + dbFile.getAbsolutePath());
        }
        return dbFile;
    }

    public static TestDvcsChangeSet createChangeSet(String id, String author, String comment, GregorianCalendar cal, String branch, List<String> parents) {
        TestDvcsChangeSet cs = new TestDvcsChangeSet(id);
        cs.setAuthor(author);
        cs.setComment(comment);
        cs.setDate(cal.getTimeInMillis());
        cs.setBranch(branch);
        cs.setParents(parents);
        return cs;
    }

    public static void createSimpleTestData(TestDvcsChangeSetDAO dao) throws DbException, LicensePolicyException {
        TestDvcsChangeSet cs0 = TestDvcsChangeSetDAO.createChangeSet(CS0, "testuser", "branch point", new GregorianCalendar(2010, 7, 1), "branch1", new ArrayList<String>());
        TestDvcsChangeSet cs1 = TestDvcsChangeSetDAO.createChangeSet(CS1, "testuser", "first change", new GregorianCalendar(2010, 7, 1), "branch1", Arrays.asList(CS0));
        TestDvcsChangeSet cs2 = TestDvcsChangeSetDAO.createChangeSet(CS2, "testuser", "second change", new GregorianCalendar(2010, 7, 2), "branch2", Arrays.asList(CS0));
        TestDvcsChangeSet cs3 = TestDvcsChangeSetDAO.createChangeSet(CS3, "testuser", "merge", new GregorianCalendar(2010, 7, 2), "branch1", Arrays.asList(CS1, CS2));
        dao.store(cs0);
        dao.store(cs1);
        dao.store(cs2);
        dao.store(cs3);
    }

    public static class TestDvcsRevInfoDAO
    extends DvcsRevInfoDAO<TestDvcsRevInfo, TestDvcsStringTables> {
        public TestDvcsRevInfoDAO(String repositoryName, InfinityDbHandle dbh, TestDvcsStringTables stringTables, LicenseEnforcer licenseEnforcer) {
            super(repositoryName, dbh, (CommonStringTables)stringTables, licenseEnforcer);
        }

        public TestDvcsRevInfo load(int revid) throws DbException {
            return null;
        }
    }

    public static class TestDvcsChangeSet
    extends ChangeSetImpl<TestDvcsRevInfo> {
        public TestDvcsChangeSet() {
            super(null, null, null);
        }

        public TestDvcsChangeSet(String commit) {
            super(commit, null, null);
        }
    }

    public static class TestDvcsStringTables
    extends CommonStringTables {
        public TestDvcsStringTables(UniqueStringTableFactory factory) {
            super(factory);
        }
    }

    public static class TestDvcsRevInfo
    extends DvcsRevInfo {
        public String getEmail() {
            return null;
        }
    }
}

