/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.dvcs.db;

import com.atlassian.fisheye.dvcs.db.DvcsRevInfo;
import com.atlassian.fisheye.dvcs.db.DvcsRevInfoDAO;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.infinitydb.Cu;
import com.infinitydb.CuAppendable;
import com.infinitydb.ItemSpace;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DvcsHeadnessTestUtil<F extends DvcsRevInfo, T extends CommonStringTables> {
    private InfinityDbHandle dbh;
    private DvcsRevInfoDAO<F, T> dao;

    public DvcsHeadnessTestUtil(InfinityDbHandle dbh, DvcsRevInfoDAO<F, T> dao) {
        this.dbh = dbh;
        this.dao = dao;
    }

    public List<F> getHeadsOnBranch(String branchName) throws DbException {
        IntArrayList revids = new IntArrayList();
        ItemSpace db = this.dbh.get();
        Cu cu = Cu.alloc();
        try {
            cu.append((CuAppendable)CommonSchema.E_HEAD_IN_BRANCH_TO_REVID).append(branchName);
            int pl = cu.length();
            while (db.next(cu, pl)) {
                int revid = (int)cu.longAt(pl);
                revids.add(revid);
            }
        }
        catch (IOException e) {
            throw new DbException((Throwable)e);
        }
        finally {
            Cu.dispose((Cu)cu);
        }
        ArrayList<FileRevision> result = new ArrayList<FileRevision>();
        for (Integer revid : revids) {
            result.add(this.dao.loadLazy(revid.intValue()));
        }
        return result;
    }

    public List<F> getHeadsOnAnyBranch() throws DbException {
        IntArrayList revids = new IntArrayList();
        ItemSpace db = this.dbh.get();
        Cu cu = Cu.alloc();
        try {
            cu.append((CuAppendable)CommonSchema.E_HEAD_IN_ANY_BRANCH_REVIDS);
            int pl = cu.length();
            while (db.next(cu, pl)) {
                int revid = (int)cu.longAt(pl);
                revids.add(revid);
            }
        }
        catch (IOException e) {
            throw new DbException((Throwable)e);
        }
        finally {
            Cu.dispose((Cu)cu);
        }
        ArrayList<FileRevision> result = new ArrayList<FileRevision>();
        for (Integer revid : revids) {
            result.add(this.dao.loadLazy(revid.intValue()));
        }
        return result;
    }
}

