/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.dvcs.db;

import com.atlassian.fisheye.dvcs.db.TestDvcsChangeSetDAO;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.UniqueStringTableFactory;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.impl.NullLicenseEnforcer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DvcsChangeSetDAOTest {
    private static final String BRANCH1 = "branch1";
    private static final String BRANCH2 = "branch2";
    private static final String REPO_NAME = "test-repo";
    private File dbFile;
    private TestDvcsChangeSetDAO csDAO;

    @Before
    public void setup() throws IOException {
        this.dbFile = TestDvcsChangeSetDAO.getInfDBTestFile("dvcscstest.idb");
        InfinityDbHandle dbHandle = new InfinityDbHandle(this.dbFile);
        TestDvcsChangeSetDAO.TestDvcsStringTables stringTables = new TestDvcsChangeSetDAO.TestDvcsStringTables((UniqueStringTableFactory)dbHandle);
        NullLicenseEnforcer dummyLm = new NullLicenseEnforcer();
        TestDvcsChangeSetDAO.TestDvcsRevInfoDAO revInfoDao = new TestDvcsChangeSetDAO.TestDvcsRevInfoDAO(REPO_NAME, dbHandle, stringTables, (LicenseEnforcer)dummyLm);
        this.csDAO = new TestDvcsChangeSetDAO(new RepositoryStatus(REPO_NAME), dbHandle, stringTables, revInfoDao, (LicenseEnforcer)dummyLm);
    }

    @After
    public void teardown() {
        this.dbFile.delete();
    }

    @Test
    public void testStoreAndLoadBranchAndMerge() throws Exception {
        TestDvcsChangeSetDAO.createSimpleTestData(this.csDAO);
        TestDvcsChangeSetDAO.TestDvcsChangeSet loaded0 = (TestDvcsChangeSetDAO.TestDvcsChangeSet)this.csDAO.load("cs0123456789");
        TestDvcsChangeSetDAO.TestDvcsChangeSet loaded1 = (TestDvcsChangeSetDAO.TestDvcsChangeSet)this.csDAO.load("cs123456789a");
        TestDvcsChangeSetDAO.TestDvcsChangeSet loaded2 = (TestDvcsChangeSetDAO.TestDvcsChangeSet)this.csDAO.load("cs23456789ab");
        TestDvcsChangeSetDAO.TestDvcsChangeSet loaded3 = (TestDvcsChangeSetDAO.TestDvcsChangeSet)this.csDAO.load("cs3456789abd");
        Assert.assertNotNull((Object)((Object)loaded0));
        Assert.assertNotNull((Object)((Object)loaded1));
        Assert.assertNotNull((Object)((Object)loaded2));
        Assert.assertNotNull((Object)((Object)loaded3));
        Assert.assertEquals((Object)BRANCH1, (Object)loaded0.getBranch());
        Assert.assertEquals(Collections.singleton(BRANCH1), (Object)loaded0.getBranches());
        Assert.assertEquals(new ArrayList(), (Object)loaded0.getParents());
        Assert.assertEquals((Object)BRANCH1, (Object)loaded1.getBranch());
        Assert.assertEquals(Collections.singleton(BRANCH1), (Object)loaded1.getBranches());
        Assert.assertEquals(Arrays.asList("cs0123456789"), (Object)loaded1.getParents());
        Assert.assertEquals((Object)BRANCH2, (Object)loaded2.getBranch());
        Assert.assertEquals(Collections.singleton(BRANCH2), (Object)loaded2.getBranches());
        Assert.assertEquals(Arrays.asList("cs0123456789"), (Object)loaded2.getParents());
        Assert.assertEquals((Object)BRANCH1, (Object)loaded3.getBranch());
        Assert.assertEquals(Collections.singleton(BRANCH1), (Object)loaded3.getBranches());
        Assert.assertEquals(Arrays.asList("cs123456789a", "cs23456789ab"), (Object)loaded3.getParents());
    }
}

