/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.dvcs.db;

import com.atlassian.fisheye.dvcs.DvcsCache;
import com.atlassian.fisheye.dvcs.client.DvcsContext;
import com.atlassian.fisheye.dvcs.db.DvcsChangeSetDAO;
import com.atlassian.fisheye.dvcs.db.DvcsRevInfoDAO;
import com.atlassian.fisheye.dvcs.db.TestDvcsChangeSetDAO;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.cache.RevisionIdentifier;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.UniqueStringTableFactory;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.LuceneIndexes;
import com.cenqua.fisheye.rep.Blame;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.IndexingContext;
import com.cenqua.fisheye.rep.Manifest;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.fisheye.rep.impl.NullLicenseEnforcer;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class DvcsCacheTest {
    private static final String REPO_NAME = "test-repo";
    private File dbFile;
    private MyCache cache;
    private DvcsRevInfoDAO<TestDvcsChangeSetDAO.TestDvcsRevInfo, TestDvcsChangeSetDAO.TestDvcsStringTables> revInfoDAO = (DvcsRevInfoDAO)Mockito.mock(DvcsRevInfoDAO.class);

    @Before
    public void setup() throws IOException {
        this.dbFile = TestDvcsChangeSetDAO.getInfDBTestFile("testdvcscachetest.idb");
        InfinityDbHandle dbHandle = new InfinityDbHandle(this.dbFile);
        TestDvcsChangeSetDAO.TestDvcsStringTables stringTables = new TestDvcsChangeSetDAO.TestDvcsStringTables((UniqueStringTableFactory)dbHandle);
        this.cache = new MyCache(new RepositoryStatus(REPO_NAME), 99L, 99, dbHandle, null, stringTables, (LicenseEnforcer)new NullLicenseEnforcer(), null, REPO_NAME, null);
    }

    @After
    public void teardown() {
        this.dbFile.delete();
    }

    @Test
    public void testGetExistsCSByPartialHash() throws Exception {
        int i;
        TestDvcsChangeSetDAO.createSimpleTestData(this.cache.csDao);
        for (i = 3; i < "cs0123456789".length(); ++i) {
            this.testExistsSubString("cs0123456789", i);
            this.testExistsSubString("cs123456789a", i);
            this.testExistsSubString("cs23456789ab", i);
            this.testExistsSubString("cs3456789abd", i);
        }
        for (i = 1; i < "cs0123456789".length(); ++i) {
            this.testNotExistsSubString("cs0123456789", i);
            this.testNotExistsSubString("cs123456789a", i);
            this.testNotExistsSubString("cs23456789ab", i);
            this.testNotExistsSubString("cs3456789abd", i);
        }
        Assert.assertFalse((boolean)this.cache.existsChangeSet("1111111111111111111111111111111111111111"));
        Assert.assertFalse((boolean)this.cache.existsChangeSet("aaaaaaaafffffffffffff5555555532283463784"));
        Assert.assertFalse((boolean)this.cache.existsChangeSet("abcdefabcdefabcdefabcdefabcdefabcdefabcd"));
        Assert.assertFalse((boolean)this.cache.existsChangeSet("2587349825749327590834275984375908324750"));
        Assert.assertFalse((boolean)this.cache.existsChangeSet("1111111111111111111111111111111122222222"));
        Assert.assertFalse((boolean)this.cache.existsChangeSet("11111111111111111111111111111111222222227597435987459"));
        Assert.assertFalse((boolean)this.cache.existsChangeSet("cs01234567891"));
        Assert.assertFalse((boolean)this.cache.existsChangeSet(null));
    }

    @Test
    public void getLatestFileRevision_shouldReturnLazyRev() throws Exception {
        Path path = new Path((CharSequence)"/foobar");
        Mockito.when((Object)this.revInfoDAO.getLatestPathRevid(path)).thenReturn((Object)16);
        TestDvcsChangeSetDAO.TestDvcsRevInfo rev = (TestDvcsChangeSetDAO.TestDvcsRevInfo)((Object)Mockito.mock(TestDvcsChangeSetDAO.TestDvcsRevInfo.class));
        Mockito.when((Object)this.revInfoDAO.loadLazy(16)).thenReturn((Object)rev);
        TestDvcsChangeSetDAO.TestDvcsRevInfo result = (TestDvcsChangeSetDAO.TestDvcsRevInfo)this.cache.getLatestFileRevision(path);
        Assert.assertThat((Object)((Object)result), (Matcher)Matchers.sameInstance((Object)((Object)rev)));
    }

    private void testExistsSubString(String cs, int i) throws DbException {
        String partialHash = cs.substring(0, i);
        String testComment = "Looking for: \"" + partialHash + "\"";
        Assert.assertTrue((String)testComment, (boolean)this.cache.existsChangeSet(partialHash));
        Assert.assertEquals((String)testComment, (Object)cs, (Object)((TestDvcsChangeSetDAO.TestDvcsChangeSet)this.cache.getChangeSet(partialHash)).getId());
    }

    private void testNotExistsSubString(String cs, int i) throws DbException {
        String partialHash = cs.substring(i);
        Assert.assertFalse((String)("Looking for: \"" + partialHash + "\""), (boolean)this.cache.existsChangeSet(partialHash));
    }

    private class MyCache
    extends DvcsCache<TestDvcsChangeSetDAO.TestDvcsRevInfo, TestDvcsChangeSetDAO.TestDvcsChangeSet, TestDvcsChangeSetDAO.TestDvcsStringTables> {
        private TestDvcsChangeSetDAO csDao;

        protected MyCache(RepositoryStatus status, long cacheSerial, int version, InfinityDbHandle dbh, LuceneConnection<LuceneIndexes> luceneConnection, TestDvcsChangeSetDAO.TestDvcsStringTables stringTables, LicenseEnforcer licenseEnforcer, IndexingContext indexingContext, String repositoryName, DvcsContext context) {
            super(status, cacheSerial, version, dbh, luceneConnection, (CommonStringTables)stringTables, licenseEnforcer, indexingContext, repositoryName, context);
            this.csDao = new TestDvcsChangeSetDAO(status, dbh, stringTables, DvcsCacheTest.this.revInfoDAO, licenseEnforcer);
        }

        public void getBinaryRevision(RevInfoKey key, OutputStream aOut) throws IOException, DbException {
        }

        public Map<Path, String> resolveRevisionsForPatch(Map<Path, RevisionIdentifier> patchRevisions) throws DbException {
            return null;
        }

        public Blame getBlameFallback(RevInfoKey revInfoKey) throws DbException, IOException {
            return null;
        }

        public ScmType getRepositoryType() {
            return ScmType.HG;
        }

        public boolean isCaseSensitive() {
            return false;
        }

        public DvcsRevInfoDAO<TestDvcsChangeSetDAO.TestDvcsRevInfo, TestDvcsChangeSetDAO.TestDvcsStringTables> getFileRevisionDAO() {
            return DvcsCacheTest.this.revInfoDAO;
        }

        public DvcsChangeSetDAO<TestDvcsChangeSetDAO.TestDvcsRevInfo, TestDvcsChangeSetDAO.TestDvcsChangeSet, TestDvcsChangeSetDAO.TestDvcsStringTables> getChangeSetDAO() {
            return this.csDao;
        }

        protected DvcsContext getContext() {
            return null;
        }

        public Manifest<TestDvcsChangeSetDAO.TestDvcsRevInfo> getManifest(String csid) throws DbException {
            return null;
        }
    }
}

