/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.dvcs.client;

import com.atlassian.fisheye.dvcs.client.DvcsLineOutputHandler;
import com.atlassian.utils.process.ProcessException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.Test;

public class DvcsLineOutputHandlerTest {
    @Test
    public void testNewlineHandling() throws ProcessException {
        this.checkExpectedLines("", 0, new String[0]);
        this.checkExpectedLines("foo", 1, "foo");
        this.checkExpectedLines("foo\n", 1, "foo");
        this.checkExpectedLines("foo\nbar", 2, "foo", "bar");
        this.checkExpectedLines("foo\r\nbar", 2, "foo", "bar");
        this.checkExpectedLines("foo\rbar", 2, "foo", "bar");
        this.checkExpectedLines("foo\u2028bar\u2029baz\u0085buz", 1, "foo", "bar", "baz", "buz");
    }

    private void checkExpectedLines(String data, int nonUnicodeLines, String ... lines) throws ProcessException {
        Assert.assertEquals((long)lines.length, (long)this.count(true, data, lines));
        Assert.assertEquals((long)nonUnicodeLines, (long)this.count(false, data, null));
    }

    private int count(boolean unicode, String data, final String[] lines) throws ProcessException {
        final int[] lineCount = new int[1];
        new DvcsLineOutputHandler(Charset.forName("UTF8"), unicode){

            protected void processLine(int lineNum, String line) {
                if (lines != null) {
                    Assert.assertEquals((Object)lines[lineNum], (Object)line);
                }
                lineCount[0] = lineCount[0] + 1;
            }
        }.process((InputStream)new ByteArrayInputStream(data.getBytes()));
        return lineCount[0];
    }
}

