/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.dvcs.client;

import com.atlassian.fisheye.dvcs.DvcsScmConfig;
import com.atlassian.fisheye.dvcs.client.DvcsCommandBuilder;
import com.atlassian.fisheye.dvcs.client.DvcsProcessFactory;
import com.atlassian.fisheye.git.GitScmConfig;
import com.atlassian.fisheye.git.client.GitCommandBuilder;
import com.atlassian.fisheye.git.client.GitContext;
import com.atlassian.utils.process.PluggableProcessHandler;
import com.atlassian.utils.process.ProcessHandler;
import com.atlassian.utils.process.ProcessMonitor;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.rep.RepositoryStatus;
import java.io.File;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class DvcsContextTest {
    @Test
    public void shouldCreateProcessesThatLogActivity() throws Exception {
        RepositoryConfig config = (RepositoryConfig)Mockito.mock(RepositoryConfig.class);
        GitScmConfig gitConfig = (GitScmConfig)Mockito.mock(GitScmConfig.class);
        Mockito.when((Object)config.getScmConfig()).thenReturn((Object)gitConfig);
        Mockito.when((Object)config.getStatus()).thenReturn((Object)new RepositoryStatus("foo"));
        DvcsProcessFactory processFactory = (DvcsProcessFactory)Mockito.mock(DvcsProcessFactory.class);
        Mockito.when((Object)gitConfig.getDvcsProcessFactory()).thenReturn((Object)processFactory);
        DvcsProcessFactory.DvcsProcessBuilder processBuilder = (DvcsProcessFactory.DvcsProcessBuilder)Mockito.mock(DvcsProcessFactory.DvcsProcessBuilder.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)processFactory.builder((DvcsScmConfig)Matchers.any(), (DvcsCommandBuilder)Matchers.any(), (ProcessHandler)Matchers.any(), (File)Matchers.any())).thenReturn((Object)processBuilder);
        GitContext context = new GitContext(config);
        context.executeCommand((DvcsCommandBuilder)new GitCommandBuilder("status", new String[0]), (ProcessHandler)new PluggableProcessHandler(), null);
        ((DvcsProcessFactory.DvcsProcessBuilder)Mockito.verify((Object)processBuilder)).monitor(new ProcessMonitor[]{context.activityMonitor});
    }
}

