/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.dvcs;

import com.atlassian.fecru.security.SshKey;
import com.atlassian.fecru.security.SshKeyManager;
import com.atlassian.fecru.security.SshKeyManagerImpl;
import com.atlassian.fecru.security.SshKeySupplier;
import com.atlassian.fecru.security.SshKeySupplierImpl;
import com.atlassian.fisheye.rep.ScannerTestHarness;
import com.cenqua.fisheye.config1.PasswordAuthenticationType;
import com.cenqua.fisheye.config1.SshKeyAuthenticationType;
import com.cenqua.fisheye.rep.BaseRepositoryEngine;
import com.cenqua.fisheye.rep.BaseRepositoryScanner;
import com.cenqua.fisheye.util.FileSystemUtils;
import com.jcraft.jsch.JSchException;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public abstract class DvcsTestHarness<E extends BaseRepositoryEngine<S, ?>, S extends BaseRepositoryScanner<?>>
extends ScannerTestHarness<E, S> {
    private final SshKeyManager sshKeyManager;
    private int maxCommitters;
    private String scmExecutable;
    private String privateKeyContents;
    private String location;

    protected DvcsTestHarness() {
        this.sshKeyManager = new SshKeyManagerImpl(this.rootConfig, new FileSystemUtils(), (SshKeySupplier)new SshKeySupplierImpl());
    }

    public String getScmExecutable() {
        return this.scmExecutable;
    }

    public int getMaxCommitters() {
        return this.maxCommitters;
    }

    public void setMaxCommitters(int maxCommitters) {
        this.maxCommitters = maxCommitters;
    }

    public void setScmExecutable(String scmExecutable) {
        this.scmExecutable = scmExecutable;
    }

    public void setPrivateKeyContents(String privateKey) {
        this.privateKeyContents = privateKey;
    }

    public String getPrivateKeyContents() {
        return this.privateKeyContents;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    protected PasswordAuthenticationType createPasswordAuthDef() throws IOException {
        if (StringUtils.isNotBlank((String)this.getPassword())) {
            PasswordAuthenticationType auth = PasswordAuthenticationType.Factory.newInstance();
            auth.setPassword(this.getPassword());
            return auth;
        }
        return null;
    }

    protected SshKeyAuthenticationType createSshAuthDef() throws IOException, JSchException {
        if (StringUtils.isNotBlank((String)this.getPrivateKeyContents())) {
            SshKeyAuthenticationType auth = SshKeyAuthenticationType.Factory.newInstance();
            auth.setKeyName(this.createPrivateKey(this.getPrivateKeyContents()));
            return auth;
        }
        return null;
    }

    protected String createPrivateKey(String contents) throws IOException, JSchException {
        SshKey key = this.getSshKeyManager().saveKeyPair(this.getRepoName() + "key", null, contents);
        return key.getName();
    }

    public SshKeyManager getSshKeyManager() {
        return this.sshKeyManager;
    }
}

